/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.persistence;

import java.util.Map;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.dummy.DummyInMemoryStoreConfigurationBuilder;
import org.infinispan.persistence.spi.CacheLoader;
import org.infinispan.persistence.spi.PersistenceException;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.impl.NodeKey;
import org.infinispan.tree.impl.TreeCacheImpl;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="persistence.TreeCacheWithLoaderTest")
public class TreeCacheWithLoaderTest
extends SingleCacheManagerTest {
    TreeCache<String, String> cache;
    CacheLoader store;

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        ConfigurationBuilder cb = this.getDefaultStandaloneCacheConfig(true);
        cb.invocationBatching().enable();
        this.addCacheStore(cb.persistence());
        EmbeddedCacheManager cm = TestCacheManagerFactory.createCacheManager((ConfigurationBuilder)cb);
        this.cache = new TreeCacheImpl(cm.getCache());
        this.store = this.extractCacheStore();
        return cm;
    }

    protected void addCacheStore(PersistenceConfigurationBuilder persistenceConfigurationBuilder) {
        ((DummyInMemoryStoreConfigurationBuilder)persistenceConfigurationBuilder.addStore(DummyInMemoryStoreConfigurationBuilder.class)).storeName(((Object)((Object)this)).getClass().getName());
    }

    public void testPersistence() throws PersistenceException {
        this.cache.put("/a/b/c", (Object)"key", (Object)"value");
        assert ("value".equals(this.cache.get("/a/b/c", (Object)"key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.fromString((String)"/a/b/c")).get("key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.STRUCTURE)));
        this.restartCache();
        assert ("value".equals(this.cache.get("/a/b/c", (Object)"key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.fromString((String)"/a/b/c")).get("key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.fromString((String)"/a/b/c"), NodeKey.Type.STRUCTURE)));
    }

    public void testRootNodePersistence() throws PersistenceException {
        this.cache.put(Fqn.ROOT, (Object)"key", (Object)"value");
        assert ("value".equals(this.cache.get(Fqn.ROOT, (Object)"key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.ROOT).get("key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.STRUCTURE)));
        this.restartCache();
        assert ("value".equals(this.cache.get(Fqn.ROOT, (Object)"key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.DATA)));
        assert ("value".equals(this.nodeContentsInCacheStore(this.store, Fqn.ROOT).get("key")));
        assert (this.store.contains((Object)new NodeKey(Fqn.ROOT, NodeKey.Type.STRUCTURE)));
    }

    public void testDuplicatePersistence() throws PersistenceException {
        this.cache.put(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k", (Object)"v");
        assert ("v".equals(this.cache.get(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k")));
        this.restartCache();
        this.cache.put(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k", (Object)"v");
        assert ("v".equals(this.cache.get(Fqn.fromElements((Object[])new Object[]{"a", "b"}), (Object)"k")));
    }

    private Map<String, String> nodeContentsInCacheStore(CacheLoader cs, Fqn fqn) throws PersistenceException {
        return (Map)cs.load((Object)new NodeKey(fqn, NodeKey.Type.DATA)).getValue();
    }

    private CacheLoader extractCacheStore() {
        return TestingUtil.getFirstLoader((Cache)this.cache.getCache());
    }

    private void restartCache() {
        this.cache.stop();
        this.cache.start();
        this.store = this.extractCacheStore();
    }
}

