/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan;

import java.util.Arrays;
import java.util.HashMap;
import org.infinispan.tree.Fqn;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="FqnTest")
public class FqnTest {
    public void testNull() {
        Fqn fqn = Fqn.ROOT;
        assert (0 == fqn.size());
        int hcode = fqn.hashCode();
        assert (hcode != -1);
    }

    public void testOne() {
        Fqn fqn = Fqn.fromElements((Object[])new Object[]{22});
        assert (1 == fqn.size());
        int hcode = fqn.hashCode();
        assert (hcode != -1);
    }

    public void testEmptyFqn() {
        Fqn f1 = Fqn.ROOT;
        Fqn f2 = Fqn.ROOT;
        assert (f1.equals((Object)f2));
    }

    public void testFqn() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        assert (3 == fqn.size());
        Fqn fqn2 = Fqn.fromElements((Object[])new Object[]{"a", "b", "c"});
        assert (3 == fqn.size());
        assert (fqn.equals((Object)fqn2));
        assert (fqn.hashCode() == fqn2.hashCode());
    }

    public void testHereogeneousNames() {
        Fqn fqn = Fqn.fromElements((Object[])new Object[]{"string", 38, true});
        assert (3 == fqn.size());
        Fqn fqn2 = Fqn.fromElements((Object[])new Object[]{"string", 38, true});
        assert (fqn.equals((Object)fqn2));
        assert (fqn.hashCode() == fqn2.hashCode());
    }

    public void testHashcode() {
        Fqn fqn1 = Fqn.fromElements((Object[])new Object[]{"a", "b", "c"});
        Fqn fqn2 = Fqn.fromString((String)"/a/b/c");
        assert (fqn1.equals((Object)fqn2));
        HashMap<Fqn, Integer> map = new HashMap<Fqn, Integer>();
        map.put(fqn1, 33);
        map.put(fqn2, 34);
        assert (map.size() == 1);
        assert (((Integer)map.get(fqn1)).equals(34));
    }

    public void testEquals() {
        Fqn fqn1 = Fqn.fromElements((Object[])new Object[]{"person/test"});
        Fqn f1 = Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"0"});
        Fqn f2 = Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"1"});
        Fqn f3 = Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"2"});
        HashMap<Fqn, String> map = new HashMap<Fqn, String>();
        map.put(f1, "0");
        map.put(f2, "1");
        map.put(f3, "2");
        assert (map.get(Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"0"})) != null);
        assert (map.get(Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"1"})) != null);
        assert (map.get(Fqn.fromRelativeElements((Fqn)fqn1, (Object[])new Object[]{"2"})) != null);
    }

    public void testEquals2() {
        Fqn f1 = Fqn.fromString((String)"/a/b/c");
        Fqn f2 = Fqn.fromString((String)"/a/b/c");
        assert (f1.equals((Object)f2));
        f2 = Fqn.fromString((String)"/a/b");
        assert (!f1.equals((Object)f2));
        f2 = Fqn.fromString((String)"/a/b/c/d");
        assert (!f1.equals((Object)f2));
    }

    public void testEquals3() {
        Fqn f1 = Fqn.fromElements((Object[])new Object[]{"a", 322649, Boolean.TRUE});
        Fqn f2 = Fqn.ROOT;
        assert (!f1.equals((Object)f2));
        assert (!f2.equals((Object)f1));
        f2 = Fqn.fromString((String)"a/322649/TRUE");
        assert (!f1.equals((Object)f2));
        f2 = Fqn.fromElements((Object[])new Object[]{"a", 322649, Boolean.FALSE});
        assert (!f1.equals((Object)f2));
        f2 = Fqn.fromElements((Object[])new Object[]{"a", 322649, Boolean.TRUE});
        assert (f1.equals((Object)f2));
    }

    public void testEquals4() {
        Fqn fqn = Fqn.fromString((String)"X");
        assert (!fqn.equals((Object)"X"));
        assert (!fqn.equals(null));
    }

    public void testNullElements() throws CloneNotSupportedException {
        Fqn fqn0 = Fqn.fromElements((Object[])new Object[]{null});
        assert (1 == fqn0.size());
        Fqn fqn1 = Fqn.fromElements((Object[])new Object[]{"NULL", null, 0});
        assert (3 == fqn1.size());
        Fqn fqn2 = Fqn.fromElements((Object[])new Object[]{"NULL", null, 0});
        assert (fqn1.hashCode() == fqn2.hashCode());
        assert (fqn1.equals((Object)fqn2));
    }

    public void testIteration() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        assert (3 == fqn.size());
        Fqn tmp_fqn = Fqn.ROOT;
        assert (0 == tmp_fqn.size());
        for (int i = 0; i < fqn.size(); ++i) {
            String s = (String)fqn.get(i);
            tmp_fqn = Fqn.fromRelativeElements((Fqn)tmp_fqn, (Object[])new Object[]{s});
            assert (tmp_fqn.size() == i + 1);
        }
        assert (3 == tmp_fqn.size());
        assert (fqn.equals((Object)tmp_fqn));
    }

    public void testIsChildOf() {
        Fqn child = Fqn.fromString((String)"/a/b");
        Fqn parent = Fqn.fromString((String)"/a");
        assert (child.isChildOf(parent));
        assert (!parent.isChildOf(child));
        assert (child.isChildOrEquals(child));
        parent = Fqn.fromString((String)"/a/b/c");
        child = Fqn.fromString((String)"/a/b/c/d/e/f/g/h/e/r/e/r/t/tt/");
        assert (child.isChildOf(parent));
    }

    public void testIsChildOf2() {
        Fqn child = Fqn.fromString((String)"/a/b/c/d");
        assert ("/b/c/d".equals(child.getSubFqn(1, child.size()).toString()));
    }

    public void testParentage() {
        Fqn fqnRoot = Fqn.ROOT;
        Fqn parent = fqnRoot.getParent();
        assert (parent.equals((Object)fqnRoot));
        Fqn fqnOne = Fqn.fromString((String)"/one");
        parent = fqnOne.getParent();
        assert (parent.equals((Object)fqnRoot));
        assert (fqnOne.isChildOf(parent));
        Fqn fqnTwo = Fqn.fromString((String)"/one/two");
        parent = fqnTwo.getParent();
        assert (parent.equals((Object)fqnOne));
        assert (fqnTwo.isChildOf(parent));
        Fqn fqnThree = Fqn.fromString((String)"/one/two/three");
        parent = fqnThree.getParent();
        assert (parent.equals((Object)fqnTwo));
        assert (fqnThree.isChildOf(parent));
    }

    public void testRoot() {
        Fqn fqn = Fqn.ROOT;
        assert (fqn.isRoot());
        fqn = Fqn.fromString((String)"/one/two");
        assert (!fqn.isRoot());
        Fqn f = Fqn.fromString((String)"/");
        assert (f.isRoot());
        assert (f.equals((Object)Fqn.ROOT));
    }

    public void testGetName() {
        Fqn integerFqn = Fqn.fromElements((Object[])new Object[]{1});
        assert ("1".equals(integerFqn.getLastElementAsString()));
        Object object = new Object();
        Fqn objectFqn = Fqn.fromElements((Object[])new Object[]{object});
        assert (object.toString().equals(objectFqn.getLastElementAsString()));
    }

    public void testSize() {
        Fqn f = Fqn.ROOT;
        assert (f.size() == 0);
        assert (f.isRoot());
        f = Fqn.fromString((String)"/");
        assert (f.size() == 0);
        assert (f.isRoot());
        f = Fqn.fromString((String)"/hello");
        assert (f.size() == 1);
        assert (!f.isRoot());
    }

    public void testGenerations() {
        Fqn f = Fqn.fromElements((Object[])new Object[]{1, 2, 3, 4, 5, 6, 7});
        assert (f.equals((Object)f.getAncestor(f.size())));
        assert (f.getParent().equals((Object)f.getAncestor(f.size() - 1)));
        assert (Fqn.ROOT.equals((Object)f.getAncestor(0)));
        assert (Fqn.fromElements((Object[])new Object[]{1}).equals((Object)f.getAncestor(1)));
        assert (Fqn.fromElements((Object[])new Object[]{1, 2}).equals((Object)f.getAncestor(2)));
        assert (Fqn.fromElements((Object[])new Object[]{1, 2, 3}).equals((Object)f.getAncestor(3)));
        assert (Fqn.fromElements((Object[])new Object[]{1, 2, 3, 4}).equals((Object)f.getAncestor(4)));
        assert (Fqn.fromElements((Object[])new Object[]{1, 2, 3, 4, 5}).equals((Object)f.getAncestor(5)));
        try {
            f.getAncestor(-1);
            assert (false);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            f.getAncestor(f.size() + 1);
            assert (false);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void testReplacingDirectAncestor() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        Fqn newParent = Fqn.fromString((String)"/hot/dog");
        Fqn expectedNewChild = Fqn.fromString((String)"/hot/dog/c");
        assert (expectedNewChild.equals((Object)fqn.replaceAncestor(fqn.getParent(), newParent)));
    }

    public void testReplacingindirectAncestor() {
        Fqn fqn = Fqn.fromString((String)"/a/b/c");
        Fqn newParent = Fqn.fromString((String)"/hot/dog");
        Fqn expectedNewChild = Fqn.fromString((String)"/hot/dog/b/c");
        Fqn replaced = fqn.replaceAncestor(fqn.getParent().getParent(), newParent);
        assert (expectedNewChild.equals((Object)replaced)) : "Expected " + expectedNewChild + " but was " + replaced;
    }

    public void testDifferentFactories() {
        Fqn[] fqns = new Fqn[6];
        int i = 0;
        fqns[i++] = Fqn.fromString((String)"/a/b/c");
        fqns[i++] = Fqn.fromRelativeElements((Fqn)Fqn.ROOT, (Object[])new Object[]{"a", "b", "c"});
        fqns[i++] = Fqn.fromElements((Object[])new Object[]{"a", "b", "c"});
        fqns[i++] = Fqn.fromList(Arrays.asList("a", "b", "c"));
        fqns[i++] = Fqn.fromRelativeList((Fqn)Fqn.ROOT, Arrays.asList("a", "b", "c"));
        fqns[i] = Fqn.fromRelativeFqn((Fqn)Fqn.ROOT, (Fqn)Fqn.fromString((String)"/a/b/c"));
        for (i = 0; i < fqns.length; ++i) {
            for (int j = 0; j < fqns.length; ++j) {
                assert (fqns[i].equals((Object)fqns[j])) : "Error on equals comparing " + i + " and " + j + ".  i = " + fqns[i] + " and j = " + fqns[j];
                assert (fqns[j].equals((Object)fqns[i])) : "Error on equals comparing " + i + " and " + j + ".  i = " + fqns[i] + " and j = " + fqns[j];
                assert (fqns[i].hashCode() == fqns[j].hashCode()) : "Error on hashcode comparing " + i + " and " + j;
            }
        }
    }
}

