/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.api.tree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executor;
import java.util.concurrent.ForkJoinPool;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.impl.NodeKey;
import org.infinispan.util.concurrent.locks.impl.InfinispanLock;
import org.infinispan.util.concurrent.locks.impl.StripedLockContainer;
import org.testng.annotations.Test;

@Test(groups={"unit"}, testName="api.tree.TreeStructureHashCodeTest")
public class TreeStructureHashCodeTest {
    public void testHashCodesAppendedCount() {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(Fqn.ROOT);
        for (int i = 0; i < 256; ++i) {
            fqns.add(Fqn.fromString((String)("/fqn" + i)));
        }
        this.doTest(fqns);
    }

    public void testHashCodesAlpha() {
        ArrayList<Fqn> fqns = new ArrayList<Fqn>();
        fqns.add(Fqn.ROOT);
        for (int i = 0; i < 256; ++i) {
            fqns.add(Fqn.fromString((String)("/" + Integer.toString(i, 36))));
        }
        this.doTest(fqns);
    }

    private void doTest(List<Fqn> fqns) {
        StripedLockContainer container = new StripedLockContainer(512);
        container.inject((Executor)ForkJoinPool.commonPool(), AbstractInfinispanTest.TIME_SERVICE);
        HashMap<InfinispanLock, Integer> distribution = new HashMap<InfinispanLock, Integer>();
        for (Fqn f : fqns) {
            NodeKey dataKey = new NodeKey(f, NodeKey.Type.DATA);
            NodeKey structureKey = new NodeKey(f, NodeKey.Type.STRUCTURE);
            this.addToDistribution(container.getLock((Object)dataKey), distribution);
            this.addToDistribution(container.getLock((Object)structureKey), distribution);
        }
        assert (distribution.size() <= container.size()) : "Cannot have more locks than the container size!";
        assert ((double)distribution.size() * 1.5 * 2.0 >= (double)container.size()) : "Poorly distributed!  Distribution size is just " + distribution.size() + " and there are " + container.size() + " shared locks";
    }

    private void addToDistribution(InfinispanLock lock, Map<InfinispanLock, Integer> map) {
        int count = 1;
        if (map.containsKey(lock)) {
            count = map.get(lock) + 1;
        }
        map.put(lock, count);
    }
}

