/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfiguration;
import org.infinispan.persistence.jpa.configuration.JpaStoreConfigurationBuilder;
import org.infinispan.test.integration.as.KeyValueEntity;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InfinispanStoreJpaIT {
    private EmbeddedCacheManager cm;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jpa.war")).addClass(InfinispanStoreJpaIT.class)).addClass(KeyValueEntity.class)).addAsResource("META-INF/persistence.xml")).addAsResource("jpa-config.xml")).add(InfinispanStoreJpaIT.manifest(), "META-INF/MANIFEST.MF");
    }

    @After
    public void cleanUp() {
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    private static Asset manifest() {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", "org.infinispan:" + Version.getModuleSlot() + " services, org.infinispan.persistence.jpa:" + Version.getModuleSlot() + " services")).exportAsString();
        return new StringAsset(manifest);
    }

    @Test
    public void testCacheManager() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((JpaStoreConfigurationBuilder)builder.persistence().addStore(JpaStoreConfigurationBuilder.class)).persistenceUnitName("org.infinispan.persistence.jpa").entityClass(KeyValueEntity.class);
        this.cm = new DefaultCacheManager(gcb.build(), builder.build());
        Cache cache = this.cm.getCache();
        KeyValueEntity entity = new KeyValueEntity("a", "a");
        cache.put((Object)entity.getK(), (Object)entity);
        Assert.assertEquals((Object)"a", (Object)((KeyValueEntity)cache.get((Object)entity.getK())).getValue());
    }

    @Test
    public void testXmlConfig() throws IOException {
        this.cm = new DefaultCacheManager("jpa-config.xml");
        Cache specificCache = this.cm.getCache("specificCache");
        this.validateConfig((Cache<String, KeyValueEntity>)specificCache);
        KeyValueEntity entity = new KeyValueEntity("k", "v");
        specificCache.put((Object)entity.getK(), (Object)entity);
    }

    private void validateConfig(Cache<String, KeyValueEntity> vehicleCache) {
        StoreConfiguration config = (StoreConfiguration)vehicleCache.getCacheConfiguration().persistence().stores().get(0);
        Assert.assertTrue((boolean)(config instanceof JpaStoreConfiguration));
        JpaStoreConfiguration jpaConfig = (JpaStoreConfiguration)config;
        Assert.assertEquals((long)1L, (long)jpaConfig.batchSize());
        Assert.assertEquals(KeyValueEntity.class, (Object)jpaConfig.entityClass());
    }
}

