/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.cdi;

import javax.cache.annotation.CacheKey;
import javax.inject.Inject;
import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.test.integration.as.cdi.GreetingCache;
import org.infinispan.test.integration.as.cdi.GreetingService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GreetingServiceIT {
    @Inject
    @GreetingCache
    private Cache<CacheKey, String> greetingCache;
    @Inject
    private GreetingService greetingService;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"cdi.war")).addPackage(GreetingServiceIT.class.getPackage())).add(GreetingServiceIT.manifest(), "META-INF/MANIFEST.MF")).addAsWebInfResource("beans.xml");
    }

    private static Asset manifest() {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", "org.infinispan.cdi.embedded:" + Version.getModuleSlot() + " services, org.infinispan.jcache:" + Version.getModuleSlot() + " services")).exportAsString();
        return new StringAsset(manifest);
    }

    @Before
    public void init() {
        this.greetingCache.clear();
        Assert.assertEquals((long)0L, (long)this.greetingCache.size());
    }

    @Test
    public void testGreetMethod() {
        Assert.assertEquals((Object)"Hello Pete :)", (Object)this.greetingService.greet("Pete"));
    }

    @Test
    public void testGreetMethodCache() {
        this.greetingService.greet("Pete");
        Assert.assertEquals((long)1L, (long)this.greetingCache.size());
        Assert.assertTrue((boolean)this.greetingCache.values().contains((Object)"Hello Pete :)"));
        this.greetingService.greet("Manik");
        Assert.assertEquals((long)2L, (long)this.greetingCache.size());
        Assert.assertTrue((boolean)this.greetingCache.values().contains((Object)"Hello Manik :)"));
        this.greetingService.greet("Pete");
        Assert.assertEquals((long)2L, (long)this.greetingCache.size());
    }
}

