/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as;

import java.io.IOException;
import org.infinispan.Cache;
import org.infinispan.commons.util.Version;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InfinispanStoreJdbcIT {
    private EmbeddedCacheManager cm;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"jdbc.war")).addClass(InfinispanStoreJdbcIT.class)).addAsResource("jdbc-config.xml")).add(InfinispanStoreJdbcIT.manifest(), "META-INF/MANIFEST.MF");
    }

    private static Asset manifest() {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", "org.infinispan:" + Version.getModuleSlot() + " services, org.infinispan.persistence.jdbc:" + Version.getModuleSlot() + " services")).exportAsString();
        return new StringAsset(manifest);
    }

    @After
    public void cleanUp() {
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    @Test
    public void testCacheManager() {
        GlobalConfigurationBuilder gcb = new GlobalConfigurationBuilder();
        gcb.defaultCacheName("default");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        ((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder.StringTableManipulationConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)builder.persistence().addStore(JdbcStringBasedStoreConfigurationBuilder.class)).table().tableNamePrefix("ISPN")).idColumnName("K")).idColumnType("VARCHAR(255)")).dataColumnName("V")).dataColumnType("BLOB")).timestampColumnName("T")).timestampColumnType("BIGINT")).dataSource().jndiUrl("java:jboss/datasources/ExampleDS");
        this.cm = new DefaultCacheManager(gcb.build(), builder.build());
        Cache cache = this.cm.getCache();
        cache.put((Object)"a", (Object)"a");
        Assert.assertEquals((Object)"a", (Object)cache.get((Object)"a"));
    }

    @Test
    public void testXmlConfig() throws IOException {
        this.cm = new DefaultCacheManager("jdbc-config.xml");
        Cache cache = this.cm.getCache("anotherCache");
        cache.put((Object)"a", (Object)"a");
        Assert.assertEquals((Object)"a", (Object)cache.get((Object)"a"));
    }
}

