/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.client;

import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.commons.util.Version;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HotRodClientIT {
    private RemoteCacheManager rcm;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"remote-client.war")).addClass(HotRodClientIT.class)).add(HotRodClientIT.manifest(), "META-INF/MANIFEST.MF");
    }

    @After
    public void cleanUp() {
        if (this.rcm != null) {
            this.rcm.stop();
        }
    }

    @Test
    public void testCacheManager() {
        this.rcm = HotRodClientIT.createCacheManager();
        RemoteCache cache = this.rcm.getCache();
        cache.clear();
        cache.put((Object)"a", (Object)"a");
        Assert.assertEquals((Object)"a", (Object)cache.get((Object)"a"));
    }

    private static Asset manifest() {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", "org.infinispan.client.hotrod:" + Version.getModuleSlot() + " services")).exportAsString();
        return new StringAsset(manifest);
    }

    private static RemoteCacheManager createCacheManager() {
        return new RemoteCacheManager(HotRodClientIT.createConfiguration(), true);
    }

    private static Configuration createConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host("127.0.0.1");
        return config.build();
    }
}

