/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as;

import javax.annotation.Resource;
import javax.enterprise.context.ApplicationScoped;
import org.infinispan.Cache;
import org.infinispan.commons.util.Version;
import org.infinispan.manager.EmbeddedCacheManager;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@ApplicationScoped
@RunWith(value=Arquillian.class)
public class InfinispanExtensionIT {
    @Resource(lookup="java:jboss/datagrid-infinispan/container/infinispan_container")
    EmbeddedCacheManager container;
    @Resource(lookup="java:jboss/datagrid-infinispan/container/infinispan_container/cache/default")
    Cache cache;

    @Deployment(name="dep1", order=1)
    public static Archive<?> dep1() {
        return InfinispanExtensionIT.createDeployment("dep1.war");
    }

    @Deployment(name="dep2", order=2)
    public static Archive<?> dep2() {
        return InfinispanExtensionIT.createDeployment("dep2.war");
    }

    private static Archive<?> createDeployment(String name) {
        return ((WebArchive)((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)name)).addClass(InfinispanExtensionIT.class)).addClass(ManagementClient.class)).addClass(ModelControllerClient.class)).add(InfinispanExtensionIT.manifest(), "META-INF/MANIFEST.MF");
    }

    private static Asset manifest() {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", InfinispanExtensionIT.createDepString("org.infinispan", "org.jgroups.extension"))).exportAsString();
        return new StringAsset(manifest);
    }

    private static String createDepString(String ... dependencies) {
        StringBuilder sb = new StringBuilder();
        for (String dep : dependencies) {
            sb.append(dep).append(":").append(Version.getModuleSlot()).append(" services,");
        }
        return sb.toString();
    }

    @Test
    @OperateOnDeployment(value="dep1")
    public void testDep1() {
        Assert.assertNotNull((Object)this.container);
        Assert.assertTrue((boolean)this.container.getCacheManagerConfiguration().isClustered());
        Assert.assertNotNull((Object)this.cache);
        this.cache.put((Object)"1", (Object)1);
        Assert.assertEquals((Object)1, (Object)this.cache.get((Object)"1"));
    }

    @Test
    @OperateOnDeployment(value="dep2")
    public void testDep2() {
        Assert.assertNotNull((Object)this.container);
        Assert.assertTrue((boolean)this.container.getCacheManagerConfiguration().isClustered());
        Assert.assertNotNull((Object)this.cache);
        Assert.assertEquals((Object)1, (Object)this.cache.get((Object)"1"));
    }
}

