/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.query;

import java.util.List;
import javax.inject.Inject;
import org.infinispan.test.integration.as.query.Book;
import org.infinispan.test.integration.as.query.GridService;
import org.jboss.arquillian.container.test.api.OperateOnDeployment;
import org.jboss.arquillian.junit.InSequence;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class BaseQueryTest {
    @Inject
    protected GridService service;

    @Test
    @InSequence(value=1)
    @OperateOnDeployment(value="dep.active-1")
    public void loadData() {
        this.storeSamples(true);
    }

    private void storeSamples(boolean index) {
        this.service.store("AB1", new Book("Hibernate in Action", "manning"), index);
        this.service.store("AB2", new Book("Seam in Action", "manning"), index);
        this.service.store("AB3", new Book("Hibernate Search in Action", "manning"), index);
    }

    @Test
    @InSequence(value=2)
    @OperateOnDeployment(value="dep.active-1")
    public void testSimpleGetOnFirstNode() {
        Book book = this.service.findById("AB1");
        Assert.assertNotNull((Object)book);
        Assert.assertEquals((Object)"Hibernate in Action", (Object)book.title);
    }

    @Test
    @InSequence(value=3)
    @OperateOnDeployment(value="dep.active-2")
    public void testSimpleGetOnSecondNode() {
        Book book = this.service.findById("AB2");
        Assert.assertNotNull((Object)book);
        Assert.assertEquals((Object)"Seam in Action", (Object)book.title);
    }

    @Test
    @InSequence(value=4)
    @OperateOnDeployment(value="dep.active-1")
    @Ignore(value="Will be fixed by ISPN-5929")
    public void testQueryOnFirstNode() {
        List<Book> matches = this.service.findFullText("action");
        Assert.assertEquals((long)3L, (long)matches.size());
        List<Book> secondMatches = this.service.findFullText("Hibernate");
        Assert.assertEquals((long)2L, (long)secondMatches.size());
    }

    @Test
    @InSequence(value=5)
    @OperateOnDeployment(value="dep.active-2")
    @Ignore(value="Will be fixed by ISPN-5929")
    public void testQueryOnSecondNode() {
        List<Book> matches = this.service.findFullText("action");
        Assert.assertEquals((long)3L, (long)matches.size());
        List<Book> secondMatches = this.service.findFullText("HibernatE");
        Assert.assertEquals((long)2L, (long)secondMatches.size());
    }

    @Test
    @InSequence(value=6)
    @OperateOnDeployment(value="dep.active-1")
    public void testWipeIndex() {
        this.service.clear();
        this.storeSamples(false);
        List<Book> matches = this.service.findFullText("action");
        Assert.assertEquals((long)0L, (long)matches.size());
        List<Book> secondMatches = this.service.findFullText("HibernatE");
        Assert.assertEquals((long)0L, (long)secondMatches.size());
    }

    @Test
    @InSequence(value=7)
    @OperateOnDeployment(value="dep.active-2")
    public void testIndexIsEmpty() {
        List<Book> matches = this.service.findFullText("action");
        Assert.assertEquals((long)0L, (long)matches.size());
        List<Book> secondMatches = this.service.findFullText("HibernatE");
        Assert.assertEquals((long)0L, (long)secondMatches.size());
    }

    @Test
    @InSequence(value=8)
    @OperateOnDeployment(value="dep.active-1")
    public void testMassIndexer() {
        this.service.rebuildIndexes();
        List<Book> matches = this.service.findFullText("action");
        Assert.assertEquals((long)3L, (long)matches.size());
        List<Book> secondMatches = this.service.findFullText("HibernatE");
        Assert.assertEquals((long)2L, (long)secondMatches.size());
    }

    @Test
    @InSequence(value=9)
    @OperateOnDeployment(value="dep.active-2")
    public void testMassIndexerResult() {
        List<Book> matches = this.service.findFullText("action");
        Assert.assertEquals((long)3L, (long)matches.size());
        List<Book> secondMatches = this.service.findFullText("HibernatE");
        Assert.assertEquals((long)2L, (long)secondMatches.size());
    }
}

