/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.query;

import java.util.List;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.lucene.search.Query;
import org.hibernate.search.query.dsl.QueryBuilder;
import org.infinispan.Cache;
import org.infinispan.context.Flag;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.test.integration.as.query.Book;

@Named
@ApplicationScoped
public class GridService {
    @Inject
    private Cache<String, Book> bookshelf;

    public void store(String isbn, Book book, boolean index) {
        if (index) {
            this.bookshelf.put((Object)isbn, (Object)book);
        } else {
            this.bookshelf.getAdvancedCache().withFlags(Flag.SKIP_INDEXING).put((Object)isbn, (Object)book);
        }
    }

    public Book findById(String isbn) {
        return (Book)this.bookshelf.get((Object)isbn);
    }

    public List<Book> findFullText(String phrase) {
        SearchManager sm = Search.getSearchManager(this.bookshelf);
        QueryBuilder queryBuilder = sm.buildQueryBuilderForClass(Book.class).get();
        Query query = queryBuilder.phrase().onField("title").sentence(phrase).createQuery();
        CacheQuery cacheQuery = sm.getQuery(query, new Class[0]);
        return cacheQuery.list();
    }

    public List<Book> findByPublisher(String publisher) {
        org.infinispan.query.dsl.Query query = Search.getQueryFactory(this.bookshelf).from(Book.class).having("publisher").eq((Object)publisher).build();
        return query.list();
    }

    public void clear() {
        this.bookshelf.clear();
    }

    public void rebuildIndexes() {
        Search.getSearchManager(this.bookshelf).getMassIndexer().start();
    }
}

