/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as;

import java.io.IOException;
import javax.enterprise.context.ApplicationScoped;
import org.infinispan.commons.util.Version;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.as.arquillian.api.ContainerResource;
import org.jboss.as.arquillian.container.ManagementClient;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.dmr.ModelNode;
import org.junit.Assert;
import org.junit.Test;
import org.junit.runner.RunWith;

@ApplicationScoped
@RunWith(value=Arquillian.class)
public class InfinispanExtensionCliIT {
    @ContainerResource(value="container.no-ispn")
    ManagementClient managementClient;

    @Test
    public void testCliContainerCreation() throws IOException {
        assert (this.managementClient != null);
        PathAddress extension = PathAddress.pathAddress((String)"extension", (String)("org.infinispan.extension:" + Version.getModuleSlot()));
        PathAddress subsystem = PathAddress.pathAddress((String)"subsystem", (String)"datagrid-infinispan");
        PathAddress container = PathAddress.pathAddress((PathAddress)subsystem.append("cache-container", "testContainer"), (PathElement[])new PathElement[0]);
        PathAddress configurations = PathAddress.pathAddress((PathAddress)container.append("configurations", "CONFIGURATIONS"), (PathElement[])new PathElement[0]);
        PathAddress config = PathAddress.pathAddress((PathAddress)configurations.append("local-cache-configuration", "local"), (PathElement[])new PathElement[0]);
        this.assertAddSuccess(extension);
        this.assertAddSuccess(subsystem);
        this.assertAddSuccess(container);
        this.assertAddSuccess(configurations);
        this.assertAddSuccess(config);
    }

    private void assertAddSuccess(PathAddress address) throws IOException {
        this.executeAndAssert(Util.createAddOperation((PathAddress)address), "success");
    }

    private void executeAndAssert(ModelNode operation, String outcome) throws IOException {
        ModelNode result = this.managementClient.getControllerClient().execute(operation);
        Assert.assertEquals((String)result.asString(), (Object)outcome, (Object)result.get("outcome").asString());
    }
}

