/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.client;

import java.util.List;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.Search;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.marshall.MarshallerUtil;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.marshall.ProtoStreamMarshaller;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.annotations.ProtoSchemaBuilder;
import org.infinispan.query.dsl.Query;
import org.infinispan.query.dsl.QueryFactory;
import org.infinispan.test.integration.as.client.Person;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class BaseHotRodQueryIT {
    private RemoteCacheManager rcm;

    private static RemoteCacheManager createCacheManager() {
        return new RemoteCacheManager(BaseHotRodQueryIT.createConfiguration(), true);
    }

    private static Configuration createConfiguration() {
        ConfigurationBuilder config = new ConfigurationBuilder();
        config.addServer().host("127.0.0.1");
        config.marshaller((Marshaller)new ProtoStreamMarshaller());
        return config.build();
    }

    @After
    public void cleanUp() {
        if (this.rcm != null) {
            this.rcm.stop();
        }
    }

    @Test
    public void testRemoteQuery() throws Exception {
        this.rcm = BaseHotRodQueryIT.createCacheManager();
        SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.rcm);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("test.proto").addClass(Person.class).build(serializationContext);
        RemoteCache metadataCache = this.rcm.getCache("___protobuf_metadata");
        metadataCache.put((Object)"test.proto", (Object)protoFile);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        RemoteCache cache = this.rcm.getCache();
        cache.clear();
        cache.put((Object)"Adrian", (Object)new Person("Adrian"));
        Assert.assertTrue((boolean)cache.containsKey((Object)"Adrian"));
        QueryFactory qf = Search.getQueryFactory((RemoteCache)cache);
        Query query = qf.from(Person.class).having("name").eq((Object)"Adrian").build();
        List list = query.execute().list();
        Assert.assertNotNull((Object)list);
        Assert.assertEquals((long)1L, (long)list.size());
        Assert.assertEquals(Person.class, ((Person)list.get(0)).getClass());
        Assert.assertEquals((Object)"Adrian", (Object)((Person)list.get((int)0)).name);
    }

    @Test
    public void testUninverting() throws Exception {
        this.rcm = BaseHotRodQueryIT.createCacheManager();
        SerializationContext serializationContext = MarshallerUtil.getSerializationContext((RemoteCacheManager)this.rcm);
        ProtoSchemaBuilder protoSchemaBuilder = new ProtoSchemaBuilder();
        String protoFile = protoSchemaBuilder.fileName("test.proto").addClass(Person.class).build(serializationContext);
        RemoteCache metadataCache = this.rcm.getCache("___protobuf_metadata");
        metadataCache.put((Object)"test.proto", (Object)protoFile);
        Assert.assertFalse((boolean)metadataCache.containsKey((Object)".errors"));
        RemoteCache cache = this.rcm.getCache();
        cache.clear();
        QueryFactory qf = Search.getQueryFactory((RemoteCache)cache);
        Query query = qf.from(Person.class).having("name").eq((Object)"John").orderBy("id").build();
        Assert.assertEquals((long)0L, (long)query.execute().list().size());
    }
}

