/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.cdi;

import javax.cache.annotation.CacheKey;
import javax.cache.annotation.CacheRemoveAll;
import javax.enterprise.context.ApplicationScoped;
import javax.inject.Inject;
import javax.inject.Named;
import org.infinispan.Cache;
import org.infinispan.CacheCollection;
import org.infinispan.eviction.EvictionType;
import org.infinispan.test.integration.as.cdi.GreetingCache;

@Named
@ApplicationScoped
public class GreetingCacheManager {
    @Inject
    @GreetingCache
    private Cache<CacheKey, String> cache;

    public String getCacheName() {
        return this.cache.getName();
    }

    public int getNumberOfEntries() {
        return this.cache.size();
    }

    public EvictionType getEvictionType() {
        return this.cache.getCacheConfiguration().memory().evictionType();
    }

    public long getMemorySize() {
        return this.cache.getCacheConfiguration().memory().size();
    }

    public long getExpirationLifespan() {
        return this.cache.getCacheConfiguration().expiration().lifespan();
    }

    public String[] getCachedValues() {
        CacheCollection cachedValues = this.cache.values();
        return cachedValues.toArray(new String[cachedValues.size()]);
    }

    @CacheRemoveAll(cacheName="greeting-cache")
    public void clearCache() {
    }
}

