/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as.cdi;

import javax.inject.Inject;
import org.infinispan.commons.util.Version;
import org.infinispan.eviction.EvictionType;
import org.infinispan.test.integration.as.cdi.GreetingCacheManager;
import org.infinispan.test.integration.as.cdi.GreetingService;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class GreetingCacheManagerIT {
    @Inject
    private GreetingService greetingService;
    @Inject
    private GreetingCacheManager greetingCacheManager;

    @Deployment
    public static Archive<?> deployment() {
        return ((WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"cdi-cm.war")).addPackage(GreetingCacheManagerIT.class.getPackage())).add(GreetingCacheManagerIT.manifest(), "META-INF/MANIFEST.MF")).addAsWebInfResource("beans.xml");
    }

    private static Asset manifest() {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", "org.infinispan:" + Version.getModuleSlot() + " services")).exportAsString();
        return new StringAsset(manifest);
    }

    @Before
    public void init() {
        this.greetingCacheManager.clearCache();
        Assert.assertEquals((long)0L, (long)this.greetingCacheManager.getNumberOfEntries());
    }

    @Test
    public void testGreetingCacheConfiguration() {
        Assert.assertEquals((Object)"greeting-cache", (Object)this.greetingCacheManager.getCacheName());
        Assert.assertEquals((long)128L, (long)this.greetingCacheManager.getMemorySize());
        Assert.assertEquals((Object)EvictionType.COUNT, (Object)this.greetingCacheManager.getEvictionType());
        Assert.assertEquals((long)-1L, (long)this.greetingCacheManager.getExpirationLifespan());
    }

    @Test
    public void testGreetingCacheCachedValues() {
        this.greetingService.greet("Pete");
        Assert.assertEquals((long)1L, (long)this.greetingCacheManager.getCachedValues().length);
        Assert.assertEquals((Object)"Hello Pete :)", (Object)this.greetingCacheManager.getCachedValues()[0]);
    }

    @Test
    public void testClearGreetingCache() {
        this.greetingService.greet("Pete");
        Assert.assertEquals((long)1L, (long)this.greetingCacheManager.getNumberOfEntries());
        this.greetingCacheManager.clearCache();
        Assert.assertEquals((long)0L, (long)this.greetingCacheManager.getNumberOfEntries());
    }
}

