/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.test.integration.as;

import org.infinispan.Cache;
import org.infinispan.Version;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.tree.Fqn;
import org.infinispan.tree.Node;
import org.infinispan.tree.TreeCache;
import org.infinispan.tree.TreeCacheFactory;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.jboss.shrinkwrap.descriptor.api.Descriptors;
import org.jboss.shrinkwrap.descriptor.api.spec.se.manifest.ManifestDescriptor;
import org.junit.After;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class InfinispanTreeIT {
    private EmbeddedCacheManager cm;

    @Deployment
    public static Archive<?> deployment() {
        WebArchive archive = (WebArchive)((WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"simple.war")).addClass(InfinispanTreeIT.class)).add(InfinispanTreeIT.manifest(), "META-INF/MANIFEST.MF");
        return archive;
    }

    @After
    public void cleanUp() {
        if (this.cm != null) {
            this.cm.stop();
        }
    }

    private static Asset manifest() {
        String manifest = ((ManifestDescriptor)((ManifestDescriptor)Descriptors.create(ManifestDescriptor.class)).attribute("Dependencies", "org.infinispan:" + Version.getModuleSlot() + " service, org.infinispan.tree:" + Version.getModuleSlot() + " services")).exportAsString();
        return new StringAsset(manifest);
    }

    @Test
    public void testCacheManager() {
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.transaction().invocationBatching().enable();
        this.cm = new DefaultCacheManager(builder.build());
        Cache cache = this.cm.getCache();
        TreeCacheFactory tcf = new TreeCacheFactory();
        TreeCache tree = tcf.createTreeCache(cache);
        Fqn leafFqn = Fqn.fromElements((Object[])new Object[]{"branch", "leaf"});
        Node leaf = tree.getRoot().addChild(leafFqn);
        leaf.put((Object)"fruit", (Object)"orange");
    }
}

