/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.hibernate.cache.v53;

import javax.inject.Inject;
import org.apache.karaf.features.FeaturesService;
import org.infinispan.it.osgi.util.CustomPaxExamRunner;
import org.infinispan.it.osgi.util.IspnKarafOptions;
import org.infinispan.it.osgi.util.MavenUtils;
import org.infinispan.it.osgi.util.PaxExamUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

@RunWith(value=CustomPaxExamRunner.class)
@ExamReactorStrategy(value={PerClass.class})
@Category(value={PerClass.class})
public class HibernateCacheIntegrationTest {
    private static final String VERSION_HIBERNATE_OSGI = "version.hibernate.osgi";
    @Inject
    private FeaturesService featuresService;
    @Inject
    private BundleContext bundleContext;

    @Configuration
    public Option[] config() throws Exception {
        String hibernate53Version = MavenUtils.getProperties().getProperty(VERSION_HIBERNATE_OSGI);
        return CoreOptions.options((Option[])new Option[]{IspnKarafOptions.karafContainer(), IspnKarafOptions.verboseKaraf(), IspnKarafOptions.runWithoutConsole(), KarafDistributionOption.keepRuntimeFolder(), IspnKarafOptions.bundlePaxExamSpi(), IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-hibernate-cache-v53", "infinispan-hibernate-cache-v53"), KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId("org.hibernate").artifactId("hibernate-osgi").type("xml").classifier("karaf").version(hibernate53Version), (String[])new String[]{"hibernate-orm"})});
    }

    @ProbeBuilder
    public TestProbeBuilder builder(TestProbeBuilder probeBuilder) {
        return PaxExamUtils.probeIsolationWorkaround(probeBuilder);
    }

    @Test
    public void testActivation() throws Exception {
        Assert.assertTrue((boolean)this.featuresService.isInstalled(this.featuresService.getFeature("hibernate-orm")));
        Assert.assertTrue((boolean)this.featuresService.isInstalled(this.featuresService.getFeature("infinispan-core")));
        Assert.assertTrue((boolean)this.featuresService.isInstalled(this.featuresService.getFeature("infinispan-hibernate-cache-v53")));
        this.assertActiveBundle("org.hibernate.orm.core");
        this.assertActiveBundle("org.infinispan.core");
    }

    private void assertActiveBundle(String symbolicName) {
        for (Bundle bundle : this.bundleContext.getBundles()) {
            if (!bundle.getSymbolicName().equals(symbolicName)) continue;
            Assert.assertEquals((String)(symbolicName + " was found, but not in an ACTIVE state."), (long)32L, (long)bundle.getState());
            return;
        }
        Assert.fail((String)("Could not find bundle: " + symbolicName));
    }
}

