/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.it.osgi.util.MavenUtils;
import org.infinispan.it.osgi.util.PaxURLUtils;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionConfigurationConsoleOption;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.MavenArtifactUrlReference;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.WrappedUrlProvisionOption;

public class IspnKarafOptions {
    private static final String PROP_VERSION_KARAF = "version.karaf";
    private static final String PROP_VERSION_PAX_EXAM = "version.pax.exam";
    private static final String PROP_VERSION_MOCKITO = "version.mockito";
    private static final String PROP_VERSION_OBJENESIS = "version.mockito_dep.objenesis";
    private static final String PROP_VERSION_BYTEBUDDY = "version.mockito_dep.bytebuddy";
    private static final String PROP_VERBOSE_KARAF = "verbose.karaf";
    private static Pattern PATTERN_HEADER = Pattern.compile("(.+)=(.+)");

    public static String karafVersion() throws Exception {
        String karafVersion = System.getProperty(PROP_VERSION_KARAF);
        if (karafVersion == null) {
            karafVersion = MavenUtils.getProperties().getProperty(PROP_VERSION_KARAF);
        }
        return karafVersion;
    }

    public static Option verboseKaraf() {
        boolean isVerbose = Boolean.getBoolean(PROP_VERBOSE_KARAF);
        LogLevelOption.LogLevel logLevel = isVerbose ? LogLevelOption.LogLevel.TRACE : LogLevelOption.LogLevel.INFO;
        LogLevelOption.LogLevel consoleLogLevel = isVerbose ? LogLevelOption.LogLevel.INFO : LogLevelOption.LogLevel.ERROR;
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"karaf.log").value("."), CoreOptions.systemProperty((String)"karaf.log.console").value(consoleLogLevel.toString()), KarafDistributionOption.logLevel((LogLevelOption.LogLevel)logLevel), CoreOptions.vmOptions((String[])new String[]{"-Dorg.ops4j.pax.logging.DefaultServiceLog.level=" + logLevel, "-Dorg.apache.logging.log4j.level=" + logLevel})});
    }

    public static Option runWithoutConsole() {
        return new KarafDistributionConfigurationConsoleOption(Boolean.valueOf(false), Boolean.valueOf(false));
    }

    public static Option karafContainer() throws Exception {
        String karafVersion = IspnKarafOptions.karafVersion();
        return KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").version(karafVersion)).useDeployFolder(false).karafVersion(karafVersion).unpackDirectory(new File("target/pax"));
    }

    public static Option featureIspnCore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-core", "infinispan-core");
    }

    public static Option featureIspnCoreAndTests() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.featureIspnCore(), IspnKarafOptions.mvnTestsAsFragmentBundle("org.infinispan", "infinispan-core", "org.infinispan.core", new String[0])});
    }

    public static Option featureRocksDBJNI() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-rocksdb", "infinispan-cachestore-rocksdb");
    }

    public static Option featureRemoteStore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-remote", "infinispan-cachestore-remote");
    }

    public static Option featureJdbcStore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-jdbc", "infinispan-cachestore-jdbc");
    }

    public static Option featureJdbcStoreAndTests() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.featureJdbcStore(), IspnKarafOptions.mvnTestsAsFragmentBundle("org.infinispan", "infinispan-cachestore-jdbc", "org.infinispan.cachestore-jdbc", new String[0])});
    }

    public static Option bundleTestNG() {
        return CoreOptions.mavenBundle().groupId("org.testng").artifactId("testng").versionAsInProject();
    }

    public static Option bundleLog4J() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.apache.logging.log4j").artifactId("log4j-api").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.apache.logging.log4j").artifactId("log4j-core").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.apache.logging.log4j").artifactId("log4j-jul").versionAsInProject()});
    }

    public static Option bundleTestAnnotations() {
        return CoreOptions.wrappedBundle((String)CoreOptions.mavenBundle().groupId("org.infinispan").artifactId("infinispan-commons-test").versionAsInProject().getURL());
    }

    public static Option featureJpaStore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-jpa", "infinispan-cachestore-jpa");
    }

    public static Option featureJpaStoreAndTests() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.featureJpaStore(), IspnKarafOptions.mvnTestsAsFragmentBundle("org.infinispan", "infinispan-cachestore-jpa", "org.infinispan.cachestore-jpa", new String[0])});
    }

    public static Option bundleMockito() throws Exception {
        String versionMockito = MavenUtils.getProperties().getProperty(PROP_VERSION_MOCKITO);
        String versionObjenesis = MavenUtils.getProperties().getProperty(PROP_VERSION_OBJENESIS);
        String versionByteBuddy = MavenUtils.getProperties().getProperty(PROP_VERSION_BYTEBUDDY);
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.objenesis").artifactId("objenesis").version(versionObjenesis), CoreOptions.mavenBundle().groupId("org.mockito").artifactId("mockito-core").version(versionMockito), CoreOptions.mavenBundle().groupId("net.bytebuddy").artifactId("byte-buddy").version(versionByteBuddy), CoreOptions.mavenBundle().groupId("net.bytebuddy").artifactId("byte-buddy-agent").version(versionByteBuddy)});
    }

    public static Option featureKarafJNDI() throws Exception {
        String karafVersion = IspnKarafOptions.karafVersion();
        String groupId = String.format("org.apache.karaf.%sfeatures", karafVersion.startsWith("2") ? "assemblies." : "");
        return KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId(groupId).artifactId("enterprise").type("xml").classifier("features").version(karafVersion), (String[])new String[]{"jndi"});
    }

    public static Option bundleH2Database() {
        return CoreOptions.mavenBundle().groupId("com.h2database").artifactId("h2").versionAsInProject();
    }

    public static Option mvnFeature(String groupId, String artifactId, String feature) {
        return KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId(groupId).artifactId(artifactId).type("xml").classifier("features").versionAsInProject(), (String[])new String[]{feature});
    }

    private static UrlProvisionOption testJarAsStreamBundle(String groupId, String artifactId) throws Exception {
        return IspnKarafOptions.asStreamBundle(CoreOptions.maven().groupId(groupId).artifactId(artifactId).type("jar").classifier("tests").versionAsInProject().getURL());
    }

    public static WrappedUrlProvisionOption mvnTestsAsFragmentBundle(String groupId, String artifactId, String hostBundle, String ... instructions) throws Exception {
        PaxURLUtils.registerURLHandlers();
        UrlProvisionOption testBundle = IspnKarafOptions.testJarAsStreamBundle(groupId, artifactId);
        String[] allInstructions = Arrays.copyOf(instructions, instructions.length + 1);
        allInstructions[instructions.length] = String.format("Fragment-Host=%s", hostBundle);
        return CoreOptions.wrappedBundle((UrlReference)testBundle).instructions(allInstructions);
    }

    public static UrlProvisionOption emptyBundle(String ... headers) throws IOException {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.putValue("Bundle-ManifestVersion", "2");
        for (String header : headers) {
            Matcher matcher = PATTERN_HEADER.matcher(header);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Invalid header: %s (expecting '%s')", header, PATTERN_HEADER.pattern()));
            }
            mainAttributes.putValue(matcher.group(1), matcher.group(2));
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream((OutputStream)buf, manifest);
        jar.close();
        return CoreOptions.streamBundle((InputStream)new ByteArrayInputStream(buf.toByteArray()));
    }

    public static UrlProvisionOption asStreamBundle(String url) throws IOException {
        return IspnKarafOptions.asStreamBundle(url, "%s");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UrlProvisionOption asStreamBundle(String url, String newURLFormat) throws IOException {
        InputStream in = new URL(String.format(newURLFormat, url)).openStream();
        try {
            UrlProvisionOption urlProvisionOption = CoreOptions.streamBundle((InputStream)in);
            return urlProvisionOption;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static Option localRepoForPAXUrl() throws Exception {
        String localRepo = MavenUtils.getLocalRepository();
        if (localRepo == null) {
            return null;
        }
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.localRepository").value(localRepo), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.localRepository", (Object)localRepo)});
    }

    public static Option hibernatePersistenceH2() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"connection.url").value("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1"), CoreOptions.systemProperty((String)"driver.class").value("org.h2.Driver")});
    }

    public static Option bundlePaxExamSpi() throws Exception {
        String version = MavenUtils.getProperties().getProperty(PROP_VERSION_PAX_EXAM);
        return CoreOptions.wrappedBundle((UrlReference)CoreOptions.mavenBundle().groupId("org.ops4j.pax.exam").artifactId("pax-exam-spi").version(version));
    }

    public static Option featurePaxUrlWrap() throws Exception {
        MavenArtifactUrlReference karafStandardRepo = CoreOptions.maven().groupId("org.apache.karaf.features").artifactId("standard").version(IspnKarafOptions.karafVersion()).classifier("features").type("xml");
        return KarafDistributionOption.features((UrlReference)karafStandardRepo, (String[])new String[]{"(wrap)"});
    }

    public static Option commonOptions() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.karafContainer(), CoreOptions.vmOptions((String[])new String[]{"-Djava.net.preferIPv4Stack=true", "-Djgroups.bind_addr=127.0.0.1"}), CoreOptions.vmOptions((String[])new String[]{"-Xmx500m", "-XX:+HeapDumpOnOutOfMemoryError", "-XX:HeapDumpPath=" + System.getProperty("user.dir")}), IspnKarafOptions.verboseKaraf(), IspnKarafOptions.runWithoutConsole(), CoreOptions.junitBundles(), KarafDistributionOption.keepRuntimeFolder(), IspnKarafOptions.featurePaxUrlWrap(), IspnKarafOptions.bundlePaxExamSpi(), IspnKarafOptions.bundleTestAnnotations(), IspnKarafOptions.localRepoForPAXUrl()});
    }

    public static Option perSuiteOptions() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.commonOptions(), IspnKarafOptions.featureKarafJNDI(), IspnKarafOptions.bundleTestNG(), IspnKarafOptions.bundleMockito(), IspnKarafOptions.featureIspnCoreAndTests(), IspnKarafOptions.featureJdbcStoreAndTests(), IspnKarafOptions.featureJpaStoreAndTests(), IspnKarafOptions.featureRocksDBJNI(), IspnKarafOptions.featureRemoteStore(), IspnKarafOptions.bundleH2Database(), IspnKarafOptions.hibernatePersistenceH2()});
    }

    static {
        PaxURLUtils.configureLocalMavenRepo();
    }
}

