/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.persistence.file;

import java.io.File;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.it.osgi.util.IspnKarafOptions;
import org.infinispan.test.TestingUtil;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerSuite;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerSuite.class})
public class SingleFileStoreFunctionalTest
extends org.infinispan.persistence.file.SingleFileStoreFunctionalTest {
    private static String tmpDirectory;

    @Configuration
    public Option[] config() throws Exception {
        return CoreOptions.options((Option[])new Option[]{IspnKarafOptions.perSuiteOptions()});
    }

    @BeforeClass
    public static void setUpTmpDir() {
        tmpDirectory = TestingUtil.tmpDirectory(SingleFileStoreFunctionalTest.class);
    }

    @AfterClass
    public static void clearTmpDir() {
        TestingUtil.recursiveFileRemove((String)tmpDirectory);
        new File(tmpDirectory).mkdirs();
    }

    @Test
    public void testTwoCachesSameCacheStore() {
        super.testTwoCachesSameCacheStore();
    }

    @Test
    public void testPreloadAndExpiry() {
        super.testPreloadAndExpiry();
    }

    @Test
    public void testPreloadStoredAsBinary() {
        super.testPreloadStoredAsBinary();
    }

    @Test
    public void testRestoreAtomicMap() throws Exception {
        super.testRestoreAtomicMap(((Object)((Object)this)).getClass().getMethod("testRestoreAtomicMap", new Class[0]));
    }

    @Test
    public void testRestoreTransactionalAtomicMap() throws Exception {
        super.testRestoreTransactionalAtomicMap(((Object)((Object)this)).getClass().getMethod("testRestoreTransactionalAtomicMap", new Class[0]));
    }

    @Test
    public void testStoreByteArrays() throws Exception {
        super.testStoreByteArrays(((Object)((Object)this)).getClass().getMethod("testStoreByteArrays", new Class[0]));
    }

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, boolean preload) {
        persistence.addSingleFileStore().location(tmpDirectory).preload(preload);
        return persistence;
    }

    @Test
    public void testParsingEmptyElement() throws Exception {
        super.testParsingEmptyElement();
    }

    @Test
    public void testParsingElement() throws Exception {
        super.testParsingElement();
    }
}

