/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.persistence.jdbc.stringbased;

import javax.sql.DataSource;
import org.h2.jdbcx.JdbcDataSource;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.it.osgi.persistence.jdbc.UnitTestDatabaseManager;
import org.infinispan.it.osgi.persistence.jdbc.stringbased.JdbcStringBasedStoreFunctionalTest;
import org.infinispan.it.osgi.util.IspnKarafOptions;
import org.infinispan.persistence.jdbc.configuration.JdbcStringBasedStoreConfigurationBuilder;
import org.junit.Before;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerSuite;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerSuite.class})
public class JdbcStringBasedStoreManagedFactoryFunctionalTest
extends JdbcStringBasedStoreFunctionalTest {
    @Override
    @Configuration
    public Option[] config() throws Exception {
        return CoreOptions.options((Option[])new Option[]{IspnKarafOptions.perSuiteOptions()});
    }

    @Before
    public void setUp() {
        Bundle bundle = FrameworkUtil.getBundle(((Object)((Object)this)).getClass());
        BundleContext bundleContext = bundle.getBundleContext();
        JdbcDataSource service = new JdbcDataSource();
        service.setURL("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1");
        service.setUser("sa");
        service.setPassword("");
        bundleContext.registerService(DataSource.class, (Object)service, null);
    }

    @Override
    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder persistence, boolean preload) {
        JdbcStringBasedStoreConfigurationBuilder store = (JdbcStringBasedStoreConfigurationBuilder)((JdbcStringBasedStoreConfigurationBuilder)persistence.addStore(JdbcStringBasedStoreConfigurationBuilder.class)).preload(preload);
        store.dataSource().jndiUrl("osgi:service/javax.sql.DataSource");
        UnitTestDatabaseManager.buildTableManipulation(store.table(), false);
        UnitTestDatabaseManager.setDialect(store);
        return persistence;
    }
}

