/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.jar.Attributes;
import java.util.jar.JarOutputStream;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.infinispan.it.osgi.util.MavenUtils;
import org.infinispan.it.osgi.util.PaxURLUtils;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.AbstractUrlProvisionOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.UrlProvisionOption;
import org.ops4j.pax.exam.options.UrlReference;
import org.ops4j.pax.exam.options.WrappedUrlProvisionOption;

public class IspnKarafOptions {
    private static final String PROP_VERSION_KARAF = "version.karaf";
    private static final String PROP_VERSION_MOCKITO = "version.mockito";
    private static final String PROP_VERSION_OBJENESIS = "version.mockito_dep.objenesis";
    private static final String PROP_VERBOSE_KARAF = "verbose.karaf";
    private static Pattern PATTERN_HEADER = Pattern.compile("(.+)=(.+)");

    public static String karafVersion() throws Exception {
        String karafVersion = System.getProperty(PROP_VERSION_KARAF);
        if (karafVersion == null) {
            karafVersion = MavenUtils.getProperties().getProperty(PROP_VERSION_KARAF);
        }
        return karafVersion;
    }

    public static Option verboseKaraf() {
        Option result = null;
        if (Boolean.parseBoolean(System.getProperty(PROP_VERBOSE_KARAF))) {
            result = KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.TRACE);
        }
        return result;
    }

    public static Option karafContainer() throws Exception {
        String karafVersion = IspnKarafOptions.karafVersion();
        return KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("tar.gz").version(karafVersion)).useDeployFolder(false).karafVersion(karafVersion).unpackDirectory(new File("target/pax"));
    }

    public static Option featureIspnCore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-core", "infinispan-core");
    }

    public static Option featureIspnCoreAndTests() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.featureIspnCore(), IspnKarafOptions.mvnTestsAsFragmentBundle("org.infinispan", "infinispan-core", "org.infinispan.core", new String[0])});
    }

    public static Option featureLevelDbJni() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-leveldb", "infinispan-cachestore-leveldb-jni");
    }

    public static Option featureRemoteStore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-remote", "infinispan-cachestore-remote");
    }

    public static Option featureJdbcStore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-jdbc", "infinispan-cachestore-jdbc");
    }

    public static Option featureJdbcStoreAndTests() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.featureJdbcStore(), CoreOptions.mavenBundle().groupId("org.testng").artifactId("testng").versionAsInProject(), IspnKarafOptions.mvnTestsAsFragmentBundle("org.infinispan", "infinispan-cachestore-jdbc", "org.infinispan.cachestore-jdbc", new String[0])});
    }

    public static Option featureJpaStore() {
        return IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-cachestore-jpa", "infinispan-cachestore-jpa");
    }

    public static Option featureJpaStoreAndTests() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.featureJpaStore(), IspnKarafOptions.bundleMockito(), CoreOptions.mavenBundle().groupId("org.testng").artifactId("testng").versionAsInProject(), IspnKarafOptions.mvnTestsAsFragmentBundle("org.infinispan", "infinispan-cachestore-jpa", "org.infinispan.cachestore-jpa", new String[0])});
    }

    public static Option bundleMockito() throws Exception {
        String versionMockito = MavenUtils.getProperties().getProperty(PROP_VERSION_MOCKITO);
        String versionObjenesis = MavenUtils.getProperties().getProperty(PROP_VERSION_OBJENESIS);
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("org.objenesis").artifactId("objenesis").version(versionObjenesis), CoreOptions.mavenBundle().groupId("org.mockito").artifactId("mockito-core").version(versionMockito)});
    }

    public static Option featureKarafJNDI() throws Exception {
        String karafVersion = IspnKarafOptions.karafVersion();
        String groupId = String.format("org.apache.karaf.%sfeatures", karafVersion.startsWith("2") ? "assemblies." : "");
        return KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId(groupId).artifactId("enterprise").type("xml").classifier("features").version(karafVersion), (String[])new String[]{"jndi"});
    }

    public static Option bundleH2Database() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.mavenBundle().groupId("com.h2database").artifactId("h2").versionAsInProject(), CoreOptions.mavenBundle().groupId("org.osgi").artifactId("org.osgi.enterprise").version("4.2.0")});
    }

    public static Option mvnFeature(String groupId, String artifactId, String feature) {
        return KarafDistributionOption.features((UrlReference)CoreOptions.maven().groupId(groupId).artifactId(artifactId).type("xml").classifier("features").versionAsInProject(), (String[])new String[]{feature});
    }

    private static UrlProvisionOption testJarAsStreamBundle(String groupId, String artifactId) throws Exception {
        return IspnKarafOptions.asStreamBundle(CoreOptions.maven().groupId(groupId).artifactId(artifactId).type("jar").classifier("tests").versionAsInProject().getURL());
    }

    public static WrappedUrlProvisionOption mvnTestsAsFragmentBundle(String groupId, String artifactId, String hostBundle, String ... instructions) throws Exception {
        PaxURLUtils.registerURLHandlers();
        UrlProvisionOption testBundle = IspnKarafOptions.asStreamBundle(IspnKarafOptions.testJarAsStreamBundle(groupId, artifactId), "assembly:%s!/!org/infinispan/test/fwk/**", new String[0]);
        String[] allInstructions = Arrays.copyOf(instructions, instructions.length + 1);
        allInstructions[instructions.length] = String.format("Fragment-Host=%s", hostBundle);
        return CoreOptions.wrappedBundle((UrlReference)testBundle).instructions(allInstructions);
    }

    public static UrlProvisionOption emptyBundle(String ... headers) throws IOException {
        Manifest manifest = new Manifest();
        Attributes mainAttributes = manifest.getMainAttributes();
        mainAttributes.put(Attributes.Name.MANIFEST_VERSION, "1.0");
        mainAttributes.putValue("Bundle-ManifestVersion", "2");
        for (String header : headers) {
            Matcher matcher = PATTERN_HEADER.matcher(header);
            if (!matcher.matches()) {
                throw new IllegalArgumentException(String.format("Invalid header: %s (expecting '%s')", header, PATTERN_HEADER.pattern()));
            }
            mainAttributes.putValue(matcher.group(1), matcher.group(2));
        }
        ByteArrayOutputStream buf = new ByteArrayOutputStream();
        JarOutputStream jar = new JarOutputStream((OutputStream)buf, manifest);
        jar.close();
        return CoreOptions.streamBundle((InputStream)new ByteArrayInputStream(buf.toByteArray()));
    }

    public static Option bundleSplitTestPackages() throws Exception {
        PaxURLUtils.registerURLHandlers();
        UrlProvisionOption splitCoreBundle = IspnKarafOptions.asStreamBundle(IspnKarafOptions.testJarAsStreamBundle("org.infinispan", "infinispan-core"), "assembly:%s!/org/infinispan/test/fwk/**", new String[0]);
        UrlProvisionOption splitJDBCBundle = IspnKarafOptions.asStreamBundle(IspnKarafOptions.testJarAsStreamBundle("org.infinispan", "infinispan-cachestore-jdbc"), "assembly:%s!/org/infinispan/test/fwk/**", new String[0]);
        WrappedUrlProvisionOption wrappedSplitCoreBundle = CoreOptions.wrappedBundle((UrlReference)splitCoreBundle).bundleSymbolicName("split-test-core").instructions(new String[]{"Export-Package=org.infinispan.test.fwk;partial=true;mandatory:=partial"});
        WrappedUrlProvisionOption wrappedSplitJDBCBundle = CoreOptions.wrappedBundle((UrlReference)splitJDBCBundle).bundleSymbolicName("split-test-jdbc").instructions(new String[]{"Export-Package=org.infinispan.test.fwk;partial=true;mandatory:=partial"});
        UrlProvisionOption wrappedSplitTestBundle = IspnKarafOptions.emptyBundle("Bundle-SymbolicName=split-test", "Export-Package=org.infinispan.test.fwk", "Require-Bundle=split-test-core,split-test-jdbc");
        return CoreOptions.composite((Option[])new Option[]{wrappedSplitCoreBundle, wrappedSplitJDBCBundle, wrappedSplitTestBundle});
    }

    public static UrlProvisionOption asStreamBundle(AbstractUrlProvisionOption<?> option, String newURLFormat, String ... args) throws MalformedURLException, IOException {
        return IspnKarafOptions.asStreamBundle(option.getURL(), newURLFormat, args);
    }

    public static UrlProvisionOption asStreamBundle(String url) throws MalformedURLException, IOException {
        return IspnKarafOptions.asStreamBundle(url, "%s", new String[0]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static UrlProvisionOption asStreamBundle(String url, String newURLFormat, String ... args) throws MalformedURLException, IOException {
        InputStream in = new URL(String.format(newURLFormat, url, args)).openStream();
        try {
            UrlProvisionOption urlProvisionOption = CoreOptions.streamBundle((InputStream)in);
            return urlProvisionOption;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    public static Option localRepoForPAXUrl() throws Exception {
        String localRepo = MavenUtils.getLocalRepository();
        if (localRepo == null) {
            return null;
        }
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"org.ops4j.pax.url.mvn.localRepository").value(localRepo), KarafDistributionOption.editConfigurationFilePut((String)"etc/org.ops4j.pax.url.mvn.cfg", (String)"org.ops4j.pax.url.mvn.localRepository", (String)localRepo)});
    }

    public static Option hibernatePersistenceH2() {
        return CoreOptions.composite((Option[])new Option[]{CoreOptions.systemProperty((String)"connection.url").value("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1"), CoreOptions.systemProperty((String)"driver.class").value("org.h2.Driver")});
    }

    public static Option commonOptions() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.karafContainer(), CoreOptions.vmOptions((String[])new String[]{"-Djava.net.preferIPv4Stack=true", "-Djgroups.bind_addr=127.0.0.1"}), IspnKarafOptions.verboseKaraf(), CoreOptions.junitBundles(), KarafDistributionOption.keepRuntimeFolder(), IspnKarafOptions.localRepoForPAXUrl()});
    }

    public static Option perSuiteOptions() throws Exception {
        return CoreOptions.composite((Option[])new Option[]{IspnKarafOptions.commonOptions(), IspnKarafOptions.featureKarafJNDI(), IspnKarafOptions.featureIspnCoreAndTests(), IspnKarafOptions.featureJdbcStoreAndTests(), IspnKarafOptions.featureJpaStoreAndTests(), IspnKarafOptions.featureLevelDbJni(), IspnKarafOptions.featureRemoteStore(), IspnKarafOptions.bundleH2Database(), IspnKarafOptions.hibernatePersistenceH2(), IspnKarafOptions.bundleSplitTestPackages()});
    }

    static {
        PaxURLUtils.configureLocalMavenRepo();
    }
}

