/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.util;

import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import org.osgi.framework.Bundle;
import org.osgi.framework.FrameworkUtil;

public class MavenUtils {
    private static final String MAVEN_PROPERTIES_FILENAME = "maven.properties";
    private static final String PROP_MAVEN_LOCAL_REPO = "localRepository";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties getProperties() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(MavenUtils.class);
        URL resource = bundle != null ? bundle.getResource(MAVEN_PROPERTIES_FILENAME) : MavenUtils.class.getClassLoader().getResource(MAVEN_PROPERTIES_FILENAME);
        Properties props = new Properties();
        try (InputStream stream = resource.openStream();){
            props.load(stream);
        }
        for (String prop : props.stringPropertyNames()) {
            String propValue = props.getProperty(prop);
            if (!String.format("${%s}", prop).equals(propValue.trim())) continue;
            props.remove(prop);
        }
        return props;
    }

    public static String getLocalRepository() throws Exception {
        String localRepo = System.getProperty(PROP_MAVEN_LOCAL_REPO);
        if (localRepo == null) {
            localRepo = MavenUtils.getProperties().getProperty(PROP_MAVEN_LOCAL_REPO);
        }
        if (localRepo == null) {
            return null;
        }
        return new File(localRepo).getAbsolutePath();
    }
}

