/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.features;

import java.net.URI;
import java.util.Properties;
import org.apache.karaf.features.FeaturesService;
import org.infinispan.it.osgi.util.IspnKarafOptions;
import org.infinispan.it.osgi.util.MavenUtils;
import org.infinispan.it.osgi.util.PaxExamUtils;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerClass;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.ServiceReference;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerClass.class})
@Category(value={PerClass.class})
public class OSGiKarafFeaturesTest {
    private static final String PROP_PROJECT_VERSION = "project.version";

    @Configuration
    public Option[] config() throws Exception {
        return CoreOptions.options((Option[])new Option[]{IspnKarafOptions.commonOptions()});
    }

    @ProbeBuilder
    public TestProbeBuilder builder(TestProbeBuilder probeBuilder) {
        return PaxExamUtils.probeIsolationWorkaround(probeBuilder);
    }

    @Test
    public void testCleanInstall() throws Exception {
        Bundle bundle = FrameworkUtil.getBundle(this.getClass());
        Assert.assertNotNull((String)"Failed to find class bundle.", (Object)bundle);
        BundleContext context = bundle.getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(FeaturesService.class);
        Assert.assertNotNull((String)"Failed to obtain a reference to the FeaturesService.", (Object)serviceReference);
        FeaturesService service = (FeaturesService)context.getService(serviceReference);
        Assert.assertNotNull((String)"Failed to obtain a FeaturesService instance.", (Object)service);
        Properties mavenProps = MavenUtils.getProperties();
        String version = mavenProps.getProperty(PROP_PROJECT_VERSION);
        Assert.assertNotNull((String)"Failed to obtain the project version from maven.", (Object)version);
        this.checkInstall(service, "infinispan-commons", "infinispan-commons", version);
        this.checkInstall(service, "infinispan-core", "infinispan-core", version);
        this.checkInstall(service, "infinispan-client-hotrod", "hotrod-client", version);
        this.checkInstall(service, "infinispan-client-hotrod", "hotrod-client-with-query", version);
        this.checkInstall(service, "infinispan-client-hotrod", "infinispan-client-hotrod", version);
        this.checkInstall(service, "infinispan-client-hotrod", "infinispan-client-hotrod-with-query", version);
        this.checkInstall(service, "infinispan-cachestore-jdbc", "infinispan-cachestore-jdbc", version);
        this.checkInstall(service, "infinispan-cachestore-remote", "infinispan-cachestore-remote", version);
        this.checkInstall(service, "infinispan-cachestore-leveldb", "infinispan-cachestore-leveldb-jni", version);
        this.checkInstall(service, "infinispan-cachestore-leveldb", "infinispan-cachestore-leveldb-java", version);
        this.checkInstall(service, "infinispan-cachestore-jpa", "infinispan-cachestore-jpa", version);
        this.checkInstall(service, "infinispan-osgi", "infinispan-osgi", version);
        this.checkInstall(service, "infinispan-embedded", "infinispan-embedded", version);
        this.checkInstall(service, "infinispan-remote", "infinispan-remote", version);
    }

    private void checkInstall(FeaturesService service, String artifactId, String feature, String version) throws Exception {
        Assert.assertNull((String)String.format("Feature '%s' version '%s' is present in the container before install!", feature, version), (Object)service.getFeature(feature, version));
        try {
            service.installFeature(feature, version);
            Assert.fail((String)"Feature install should fail before the repository is added.");
        }
        catch (Exception exception) {
            // empty catch block
        }
        URI repoUri = new URI(String.format("mvn:org.infinispan/%s/%s/xml/features", artifactId, version));
        service.addRepository(repoUri);
        service.installFeature(feature, version);
        Assert.assertNotNull((String)String.format("Feature '%s' version '%s' install failed.", feature, version), (Object)service.getFeature(feature, version));
        service.uninstallFeature(feature, version);
        service.removeRepository(repoUri);
        Assert.assertNull((String)String.format("Feature '%s' version '%s' is still present in the container after uninstall!", feature, version), (Object)service.getFeature(feature, version));
    }
}

