/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.tx;

import java.io.Serializable;
import java.util.List;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.it.osgi.util.IspnKarafOptions;
import org.infinispan.it.osgi.util.PaxExamUtils;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerSuite;

@RunWith(value=PaxExam.class)
@ExamReactorStrategy(value={PerSuite.class})
@Category(value={PerSuite.class})
public class CustomObjectsReplicatedCacheTest
extends MultipleCacheManagersTest {
    protected void createCacheManagers() {
    }

    @Configuration
    public Option[] config() throws Exception {
        return CoreOptions.options((Option[])new Option[]{IspnKarafOptions.perSuiteOptions()});
    }

    @ProbeBuilder
    public TestProbeBuilder probe(TestProbeBuilder probeBuilder) {
        return PaxExamUtils.exportTestPackages(probeBuilder);
    }

    @Before
    public void setUp() {
        TestResourceTracker.testThreadStarted((AbstractInfinispanTest)this);
        ConfigurationBuilder c = CustomObjectsReplicatedCacheTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.REPL_SYNC, (boolean)true);
        this.createCluster(c, 2);
    }

    @After
    public void tearDown() {
        TestingUtil.killCacheManagers((List)this.cacheManagers);
    }

    @Test
    public void testCustomObjectClustered() {
        Person p = new Person("Martin");
        this.cache(0).put((Object)"k1", (Object)p);
        Assert.assertEquals((Object)p, (Object)this.cache(1).get((Object)"k1"));
    }

    static class Person
    implements Serializable {
        final String name;

        public Person(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Person person = (Person)o;
            return this.name.equals(person.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }
    }
}

