/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;

public class CustomPaxExamRunner
extends PaxExam {
    private static InputStream savedIn;

    public CustomPaxExamRunner(Class<?> klass) throws InitializationError {
        super(CustomPaxExamRunner.replaceSystemIn(klass));
    }

    private static Class<?> replaceSystemIn(Class<?> klass) {
        savedIn = System.in;
        System.setIn(new ByteArrayInputStream(new byte[0]));
        return klass;
    }

    public void run(RunNotifier notifier) {
        notifier.addListener(new RunListener(){

            public void testStarted(Description description) throws Exception {
                Class testClass = description.getTestClass();
                if (testClass == null) {
                    return;
                }
                Category categoryAnnotation = testClass.getAnnotation(Category.class);
                if (categoryAnnotation == null) {
                    throw new IllegalStateException("Class " + testClass.getName() + " doesn't have a @Category annotation. All tests in the integrationtests/osgi module must have matching @Category and @ExamReactorStrategy annotations.");
                }
                ExamReactorStrategy reactorStrategyAnnotation = testClass.getAnnotation(ExamReactorStrategy.class);
                if (reactorStrategyAnnotation == null) {
                    throw new IllegalStateException("Class " + testClass.getName() + " doesn't have a @ExamReactorStrategy annotation. All tests in the integrationtests/osgi module must have matching @Category and @ExamReactorStrategy annotations.");
                }
                if (!Arrays.equals(categoryAnnotation.value(), reactorStrategyAnnotation.value())) {
                    throw new IllegalStateException("The @Category and @ExamReactorStrategy annotations in class " + testClass.getName() + " do not match.");
                }
            }

            public void testRunStarted(Description description) throws Exception {
                super.testRunStarted(description);
            }
        });
        super.run(notifier);
    }
}

