/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.persistence.rocksdb;

import org.infinispan.commons.util.Util;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.it.osgi.util.CustomPaxExamRunner;
import org.infinispan.it.osgi.util.IspnKarafOptions;
import org.infinispan.persistence.BaseStoreFunctionalTest;
import org.infinispan.persistence.rocksdb.configuration.RocksDBStoreConfigurationBuilder;
import org.infinispan.test.AbstractInfinispanTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestResourceTracker;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerSuite;

@RunWith(value=CustomPaxExamRunner.class)
@ExamReactorStrategy(value={PerSuite.class})
@Category(value={PerSuite.class})
public class RocksDBStoreFunctionalTest
extends BaseStoreFunctionalTest {
    private static String tmpDirectory;

    @Configuration
    public Option[] config() throws Exception {
        return CoreOptions.options((Option[])new Option[]{IspnKarafOptions.perSuiteOptions()});
    }

    @BeforeClass
    public static void setUpTempDir() {
        tmpDirectory = TestingUtil.tmpDirectory(RocksDBStoreFunctionalTest.class);
    }

    @AfterClass
    public static void clearTempDir() {
        Util.recursiveFileRemove((String)tmpDirectory);
    }

    @Before
    public void setup() throws Exception {
        TestResourceTracker.testThreadStarted((AbstractInfinispanTest)this);
        super.setup();
    }

    @After
    public void teardown() {
        super.teardown();
    }

    protected PersistenceConfigurationBuilder createCacheStoreConfig(PersistenceConfigurationBuilder p, boolean preload) {
        this.createStoreBuilder(p).preload(preload);
        return p;
    }

    @Test
    public void testTwoCachesSameCacheStore() {
        super.testTwoCachesSameCacheStore();
    }

    @Test
    public void testPreloadAndExpiry() {
        super.testPreloadAndExpiry();
    }

    @Test
    public void testPreloadStoredAsBinary() {
        super.testPreloadStoredAsBinary();
    }

    @Test
    public void testRestoreAtomicMap() throws Exception {
        super.testRestoreAtomicMap(((Object)((Object)this)).getClass().getMethod("testRestoreAtomicMap", new Class[0]));
    }

    @Test
    public void testRestoreTransactionalAtomicMap() throws Exception {
        super.testRestoreTransactionalAtomicMap(((Object)((Object)this)).getClass().getMethod("testRestoreTransactionalAtomicMap", new Class[0]));
    }

    @Test
    public void testStoreByteArrays() throws Exception {
        super.testStoreByteArrays(((Object)((Object)this)).getClass().getMethod("testStoreByteArrays", new Class[0]));
    }

    RocksDBStoreConfigurationBuilder createStoreBuilder(PersistenceConfigurationBuilder loaders) {
        return ((RocksDBStoreConfigurationBuilder)loaders.addStore(RocksDBStoreConfigurationBuilder.class)).location(tmpDirectory + "/data").expiredLocation(tmpDirectory + "/expiry").clearThreshold(2);
    }
}

