/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.lang.reflect.Field;
import java.util.Arrays;
import org.junit.experimental.categories.Category;
import org.junit.runner.Description;
import org.junit.runner.notification.RunListener;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.InitializationError;
import org.ops4j.pax.exam.junit.PaxExam;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerSuite;
import org.ops4j.pax.exam.spi.reactors.SingletonStagedReactor;

public class CustomPaxExamRunner
extends PaxExam {
    private static InputStream savedIn;
    private static Class<?> hookTriggerClass;
    private final Class<?> testClass;

    public CustomPaxExamRunner(Class<?> klass) throws InitializationError {
        super(CustomPaxExamRunner.replaceSystemIn(klass));
        this.testClass = klass;
    }

    private static Class<?> replaceSystemIn(Class<?> klass) {
        if (savedIn == null) {
            savedIn = System.in;
            System.setIn(new ByteArrayInputStream(new byte[0]));
        }
        return klass;
    }

    public void run(RunNotifier notifier) {
        ExamReactorStrategy strategy = this.testClass.getAnnotation(ExamReactorStrategy.class);
        if (strategy == null || Arrays.asList(strategy.value()).contains(PerSuite.class)) {
            CustomPaxExamRunner.addShutdownHook(this.testClass);
        }
        notifier.addListener(new RunListener(){

            public void testStarted(Description description) {
                CustomPaxExamRunner.this.requireMatchingAnnotations(description);
            }

            public void testRunStarted(Description description) {
            }
        });
        super.run(notifier);
    }

    private void requireMatchingAnnotations(Description description) {
        Class testClass = description.getTestClass();
        if (testClass == null) {
            return;
        }
        Category categoryAnnotation = testClass.getAnnotation(Category.class);
        if (categoryAnnotation == null) {
            throw new IllegalStateException("Class " + testClass.getName() + " doesn't have a @Category annotation. All tests in the integrationtests/osgi module must have matching @Category and @ExamReactorStrategy annotations.");
        }
        ExamReactorStrategy reactorStrategyAnnotation = testClass.getAnnotation(ExamReactorStrategy.class);
        if (reactorStrategyAnnotation == null) {
            throw new IllegalStateException("Class " + testClass.getName() + " doesn't have a @ExamReactorStrategy annotation. All tests in the integrationtests/osgi module must have matching @Category and @ExamReactorStrategy annotations.");
        }
        if (!Arrays.equals(categoryAnnotation.value(), reactorStrategyAnnotation.value())) {
            throw new IllegalStateException("The @Category and @ExamReactorStrategy annotations in class " + testClass.getName() + " do not match.");
        }
    }

    private static void addShutdownHook(Class<?> klass) {
        if (hookTriggerClass != null) {
            return;
        }
        hookTriggerClass = klass;
        Runtime.getRuntime().addShutdownHook(new Thread("CustomPaxExamRunner-ShutdownHook"){

            @Override
            public void run() {
                CustomPaxExamRunner.stopSingletonStagedReactor();
            }
        });
    }

    private static void stopSingletonStagedReactor() {
        try {
            Field instanceField = SingletonStagedReactor.class.getDeclaredField("instance");
            instanceField.setAccessible(true);
            SingletonStagedReactor instance = (SingletonStagedReactor)instanceField.get(null);
            System.out.println("Forcing shutdown of Karaf container for test " + hookTriggerClass);
            instance.afterSuite();
        }
        catch (Exception e) {
            System.err.println("Failed to shut down suite reactor: " + e.getMessage());
        }
    }

    static {
        hookTriggerClass = null;
    }
}

