/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi;

import java.io.File;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Hashtable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.infinispan.it.osgi.util.CustomPaxExamRunner;
import org.infinispan.it.osgi.util.IspnKarafOptions;
import org.infinispan.it.osgi.util.OSGiTestUtils;
import org.infinispan.it.osgi.util.PaxExamUtils;
import org.infinispan.manager.EmbeddedCacheManager;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.ops4j.pax.exam.Configuration;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.ProbeBuilder;
import org.ops4j.pax.exam.TestProbeBuilder;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.spi.reactors.ExamReactorStrategy;
import org.ops4j.pax.exam.spi.reactors.PerMethod;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.service.cm.ConfigurationAdmin;

@RunWith(value=CustomPaxExamRunner.class)
@ExamReactorStrategy(value={PerMethod.class})
@Category(value={PerMethod.class})
public class InfinispanEmbeddedServiceFactoryTest {
    @Configuration
    public Option[] config() throws Exception {
        return new Option[]{IspnKarafOptions.commonOptions(), IspnKarafOptions.mvnFeature("org.infinispan", "infinispan-osgi", "infinispan-osgi"), KarafDistributionOption.replaceConfigurationFile((String)"/etc/custom-etc-infinispan-config.xml", (File)OSGiTestUtils.getResourceFile("org/infinispan/it/osgi/custom-config-3.xml")), KarafDistributionOption.editConfigurationFileExtend((String)"etc/config.properties", (String)"org.osgi.framework.executionenvironment", (Object)"JavaSE-1.8")};
    }

    @ProbeBuilder
    public TestProbeBuilder probe(TestProbeBuilder probeBuilder) {
        return PaxExamUtils.exportTestPackages(PaxExamUtils.probeIsolationWorkaround(probeBuilder));
    }

    @Test
    public void testNoConfiguration() throws Exception {
        BundleContext bundleContext = OSGiTestUtils.getBundleContext(this);
        ConfigurationAdmin configurationService = OSGiTestUtils.getService(bundleContext, ConfigurationAdmin.class);
        org.osgi.service.cm.Configuration[] configurations = configurationService.listConfigurations("(service.pid=org.infinispan.manager.embedded)");
        Assert.assertNull((String)"No configurations are expected.", (Object)configurations);
        Collection serviceReferences = bundleContext.getServiceReferences(EmbeddedCacheManager.class, "(service.pid=org.infinispan.manager.embedded)");
        Assert.assertEquals((String)"No service is expected.", (long)0L, (long)serviceReferences.size());
    }

    @Test
    public void testMissingConfigProperties() throws Exception {
        BundleContext bundleContext = OSGiTestUtils.getBundleContext(this);
        ConfigurationAdmin configurationService = OSGiTestUtils.getService(bundleContext, ConfigurationAdmin.class);
        org.osgi.service.cm.Configuration[] configurations = configurationService.listConfigurations("(service.pid=org.infinispan.manager.embedded)");
        Assert.assertNull((String)"No configurations are expected.", (Object)configurations);
        org.osgi.service.cm.Configuration configuration = configurationService.createFactoryConfiguration("org.infinispan.manager.embedded", null);
        configuration.update();
        Collection serviceReferences = bundleContext.getServiceReferences(EmbeddedCacheManager.class, "(service.pid=org.infinispan.manager.embedded)");
        Assert.assertNotNull((String)"No service is expected.", (Object)serviceReferences);
        Assert.assertEquals((String)"No service is expected.", (long)0L, (long)serviceReferences.size());
    }

    @Test
    public void testConfigurationPresent() throws Exception {
        BundleContext bundleContext = OSGiTestUtils.getBundleContext(this);
        final CountDownLatch expectedServiceRegistrations = new CountDownLatch(3);
        bundleContext.addServiceListener(new ServiceListener(){

            public void serviceChanged(ServiceEvent event) {
                if (event.getType() == 1) {
                    expectedServiceRegistrations.countDown();
                }
            }
        }, "(objectClass=org.infinispan.manager.EmbeddedCacheManager)");
        ConfigurationAdmin configurationService = OSGiTestUtils.getService(bundleContext, ConfigurationAdmin.class);
        org.osgi.service.cm.Configuration[] configurations = configurationService.listConfigurations("(service.pid=org.infinispan.manager.embedded)");
        Assert.assertNull((String)"No configurations are expected.", (Object)configurations);
        Hashtable<String, String> configProperties = new Hashtable<String, String>();
        ((Dictionary)configProperties).put("instanceId", "instance1");
        ((Dictionary)configProperties).put("config", "org/infinispan/it/osgi/custom-config-1.xml");
        org.osgi.service.cm.Configuration configuration = configurationService.createFactoryConfiguration("org.infinispan.manager.embedded", null);
        configuration.update(configProperties);
        configProperties = new Hashtable();
        ((Dictionary)configProperties).put("instanceId", "instance2");
        ((Dictionary)configProperties).put("config", "org/infinispan/it/osgi/custom-config-2.xml");
        configuration = configurationService.createFactoryConfiguration("org.infinispan.manager.embedded", null);
        configuration.update(configProperties);
        configProperties = new Hashtable();
        ((Dictionary)configProperties).put("instanceId", "instance3");
        ((Dictionary)configProperties).put("config", "etc/custom-etc-infinispan-config.xml");
        configuration = configurationService.createFactoryConfiguration("org.infinispan.manager.embedded", null);
        configuration.update(configProperties);
        expectedServiceRegistrations.await(10L, TimeUnit.SECONDS);
        Collection serviceReferences = bundleContext.getServiceReferences(EmbeddedCacheManager.class, "(instanceId=instance1)");
        Assert.assertEquals((String)"Expecting the service to be registered through the mananged service factory.", (long)1L, (long)serviceReferences.size());
        serviceReferences = bundleContext.getServiceReferences(EmbeddedCacheManager.class, "(instanceId=instance2)");
        Assert.assertEquals((String)"Expecting the service to be registered through the mananged service factory.", (long)1L, (long)serviceReferences.size());
        serviceReferences = bundleContext.getServiceReferences(EmbeddedCacheManager.class, "(instanceId=instance3)");
        Assert.assertEquals((String)"Expecting the service to be registered through the mananged service factory.", (long)1L, (long)serviceReferences.size());
    }
}

