/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.it.osgi.persistence.jdbc;

import java.util.concurrent.atomic.AtomicInteger;
import org.h2.Driver;
import org.infinispan.persistence.jdbc.DatabaseType;
import org.infinispan.persistence.jdbc.configuration.AbstractJdbcStoreConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.ConnectionFactoryConfigurationBuilder;
import org.infinispan.persistence.jdbc.configuration.TableManipulationConfigurationBuilder;

public class UnitTestDatabaseManager {
    private static AtomicInteger userIndex = new AtomicInteger(0);
    private static final String H2_DRIVER = Driver.class.getName();
    private static final DatabaseType dt;

    public static void setDialect(AbstractJdbcStoreConfigurationBuilder<?, ?> builder) {
        builder.dialect(dt);
    }

    public static ConnectionFactoryConfigurationBuilder<?> configureUniqueConnectionFactory(AbstractJdbcStoreConfigurationBuilder<?, ?> store) {
        return store.connectionPool().driverClass(Driver.class).connectionUrl(String.format("jdbc:h2:mem:%s;DB_CLOSE_DELAY=-1", UnitTestDatabaseManager.extractTestName() + userIndex.incrementAndGet())).username("sa");
    }

    private static String extractTestName() {
        StackTraceElement[] stack = Thread.currentThread().getStackTrace();
        if (stack.length == 0) {
            return null;
        }
        for (int i = stack.length - 1; i > 0; --i) {
            StackTraceElement e = stack[i];
            String className = e.getClassName();
            if (className.indexOf("org.infinispan") == -1) continue;
            return className.replace('.', '_') + "_" + e.getMethodName();
        }
        return null;
    }

    public static void buildTableManipulation(TableManipulationConfigurationBuilder<?, ?> table) {
        table.tableNamePrefix("ISPN_STRING").idColumnName("ID_COLUMN").idColumnType("VARCHAR(255)").dataColumnName("DATA_COLUMN").dataColumnType("BLOB").timestampColumnName("TIMESTAMP_COLUMN").timestampColumnType("BIGINT");
    }

    static {
        String driver = "";
        try {
            driver = H2_DRIVER;
            dt = DatabaseType.H2;
            try {
                Class.forName(driver);
            }
            catch (ClassNotFoundException e) {
                driver = H2_DRIVER;
                Class.forName(H2_DRIVER);
            }
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

