/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.io.Serializable;
import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.concurrent.Callable;
import javax.security.auth.Subject;
import org.infinispan.Cache;
import org.infinispan.commons.util.concurrent.NotifyingFuture;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.distexec.mapreduce.Collector;
import org.infinispan.distexec.mapreduce.MapReduceTask;
import org.infinispan.distexec.mapreduce.Mapper;
import org.infinispan.distexec.mapreduce.Reducer;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.SurefireTestingPolicy;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.ExecutionAuthorizationTest")
public class ExecutionAuthorizationTest
extends MultipleCacheManagersTest {
    private static final String EXECUTION_CACHE = "executioncache";
    Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin"});
    Subject EXEC = TestingUtil.makeSubject((String[])new String[]{"exec"});
    Subject NOEXEC = TestingUtil.makeSubject((String[])new String[]{"noexec"});

    protected void createCacheManagers() throws Throwable {
        final ConfigurationBuilder builder = ExecutionAuthorizationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.security().authorization().enable().role("admin").role("exec").role("noexec");
        Subject.doAs(this.ADMIN, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ExecutionAuthorizationTest.this.addClusterEnabledCacheManager(ExecutionAuthorizationTest.this.getSecureClusteredGlobalConfiguration(), builder);
                ExecutionAuthorizationTest.this.addClusterEnabledCacheManager(ExecutionAuthorizationTest.this.getSecureClusteredGlobalConfiguration(), builder);
                for (EmbeddedCacheManager cm : ExecutionAuthorizationTest.this.cacheManagers) {
                    cm.defineConfiguration(ExecutionAuthorizationTest.EXECUTION_CACHE, builder.build());
                    cm.getCache(ExecutionAuthorizationTest.EXECUTION_CACHE);
                }
                ExecutionAuthorizationTest.this.waitForClusterToForm(ExecutionAuthorizationTest.EXECUTION_CACHE);
                return null;
            }
        });
    }

    private GlobalConfigurationBuilder getSecureClusteredGlobalConfiguration() {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL).role("exec").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).permission(AuthorizationPermission.EXEC).role("noexec").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE);
        return global;
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        Subject.doAs(this.ADMIN, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                ExecutionAuthorizationTest.super.destroy();
                return null;
            }
        });
    }

    @AfterClass(alwaysRun=true)
    protected void clearContent() throws Exception {
        Subject.doAs(this.ADMIN, new PrivilegedExceptionAction<Void>(){

            @Override
            public Void run() throws Exception {
                try {
                    ExecutionAuthorizationTest.super.clearContent();
                }
                catch (Throwable e) {
                    throw new Exception(e);
                }
                return null;
            }
        });
    }

    private void distExecTest() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.cache(0, EXECUTION_CACHE));
        NotifyingFuture future = des.submit((Callable)new SimpleCallable());
        AssertJUnit.assertEquals((Object)1, (Object)future.get());
    }

    public void testExecDistExec() throws Exception {
        Policy.setPolicy(new SurefireTestingPolicy());
        System.setSecurityManager(new SecurityManager());
        try {
            Subject.doAs(this.EXEC, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    ExecutionAuthorizationTest.this.distExecTest();
                    return null;
                }
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testNoExecDistExec() throws Exception {
        Policy.setPolicy(new SurefireTestingPolicy());
        try {
            System.setSecurityManager(new SecurityManager());
            Subject.doAs(this.NOEXEC, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    ExecutionAuthorizationTest.this.distExecTest();
                    return null;
                }
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }

    private void mapReduceTest() {
        Cache c1 = this.cache(0, EXECUTION_CACHE);
        Cache c2 = this.cache(1, EXECUTION_CACHE);
        c1.put((Object)"1", (Object)"Hello world here I am");
        c2.put((Object)"2", (Object)"Infinispan rules the world");
        c1.put((Object)"3", (Object)"JUDCon is in Boston");
        c2.put((Object)"4", (Object)"JBoss World is in Boston as well");
        c1.put((Object)"12", (Object)"JBoss Application Server");
        c2.put((Object)"15", (Object)"Hello world");
        c1.put((Object)"14", (Object)"Infinispan community");
        c1.put((Object)"111", (Object)"Infinispan open source");
        c2.put((Object)"112", (Object)"Boston is close to Toronto");
        c1.put((Object)"113", (Object)"Toronto is a capital of Ontario");
        c2.put((Object)"114", (Object)"JUDCon is cool");
        c1.put((Object)"211", (Object)"JBoss World is awesome");
        c2.put((Object)"212", (Object)"JBoss rules");
        c1.put((Object)"213", (Object)"JBoss division of RedHat ");
        c2.put((Object)"214", (Object)"RedHat community");
        MapReduceTask task = new MapReduceTask(c1);
        task.mappedWith((Mapper)new WordCountMapper()).reducedWith((Reducer)new WordCountReducer());
        task.execute();
    }

    public void testExecMapReduce() {
        Policy.setPolicy(new SurefireTestingPolicy());
        System.setSecurityManager(new SecurityManager());
        try {
            Subject.doAs(this.EXEC, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExecutionAuthorizationTest.this.mapReduceTest();
                    return null;
                }
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testNoExecMapReduce() {
        Policy.setPolicy(new SurefireTestingPolicy());
        try {
            System.setSecurityManager(new SecurityManager());
            Subject.doAs(this.NOEXEC, new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    ExecutionAuthorizationTest.this.mapReduceTest();
                    return null;
                }
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }

    static class WordCountReducer
    implements Reducer<String, Integer> {
        private static final long serialVersionUID = 1901016598354633256L;

        WordCountReducer() {
        }

        public Integer reduce(String key, Iterator<Integer> iter) {
            int sum = 0;
            while (iter.hasNext()) {
                sum += iter.next().intValue();
            }
            return sum;
        }
    }

    static class WordCountMapper
    implements Mapper<String, String, String, Integer> {
        private static final long serialVersionUID = -5943370243108735560L;

        WordCountMapper() {
        }

        public void map(String key, String value, Collector<String, Integer> collector) {
            if (value == null) {
                throw new IllegalArgumentException("Key " + key + " has value " + value);
            }
            StringTokenizer tokens = new StringTokenizer(value);
            while (tokens.hasMoreElements()) {
                String s = (String)tokens.nextElement();
                collector.emit((Object)s, (Object)1);
            }
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable {
        private static final long serialVersionUID = -8589149500259272402L;

        @Override
        public Integer call() throws Exception {
            return 1;
        }
    }
}

