/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.io.Serializable;
import java.security.Policy;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import javax.security.auth.Subject;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.distexec.DefaultExecutorService;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.marshall.core.ExternalPojo;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.SurefireTestingPolicy;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.test.MultipleCacheManagersTest;
import org.infinispan.test.TestingUtil;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.ExecutionAuthorizationTest")
public class ExecutionAuthorizationTest
extends MultipleCacheManagersTest {
    private static final String EXECUTION_CACHE = "executioncache";
    private static Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin"});
    private static Subject EXEC = TestingUtil.makeSubject((String[])new String[]{"exec"});
    private static Subject NOEXEC = TestingUtil.makeSubject((String[])new String[]{"noexec"});

    protected void createCacheManagers() throws Throwable {
        ConfigurationBuilder builder = ExecutionAuthorizationTest.getDefaultClusteredCacheConfig((CacheMode)CacheMode.DIST_SYNC, (boolean)true);
        builder.security().authorization().enable().role("admin").role("exec").role("noexec");
        Subject.doAs(ADMIN, () -> {
            this.addClusterEnabledCacheManager(this.getSecureClusteredGlobalConfiguration(), builder);
            this.addClusterEnabledCacheManager(this.getSecureClusteredGlobalConfiguration(), builder);
            for (EmbeddedCacheManager cm : this.cacheManagers) {
                cm.defineConfiguration(EXECUTION_CACHE, builder.build());
                cm.getCache(EXECUTION_CACHE);
            }
            this.waitForClusterToForm(EXECUTION_CACHE);
            return null;
        });
    }

    private GlobalConfigurationBuilder getSecureClusteredGlobalConfiguration() {
        GlobalConfigurationBuilder global = GlobalConfigurationBuilder.defaultClusteredBuilder();
        global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL).role("exec").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).permission(AuthorizationPermission.EXEC).role("noexec").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE);
        return global;
    }

    @AfterClass(alwaysRun=true)
    protected void destroy() {
        Subject.doAs(ADMIN, () -> {
            ExecutionAuthorizationTest.super.destroy();
            return null;
        });
    }

    @AfterClass(alwaysRun=true)
    protected void clearContent() throws Exception {
        Subject.doAs(ADMIN, () -> {
            try {
                ExecutionAuthorizationTest.super.clearContent();
            }
            catch (Throwable e) {
                throw new Exception(e);
            }
            return null;
        });
    }

    private void distExecTest() throws Exception {
        DefaultExecutorService des = new DefaultExecutorService(this.cache(0, EXECUTION_CACHE));
        CompletableFuture future = des.submit((Callable)new SimpleCallable());
        AssertJUnit.assertEquals((Object)1, future.get());
    }

    public void testExecDistExec() throws Exception {
        Policy.setPolicy(new SurefireTestingPolicy());
        System.setSecurityManager(new SecurityManager());
        try {
            Subject.doAs(EXEC, () -> {
                this.distExecTest();
                return null;
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testNoExecDistExec() throws Exception {
        Policy.setPolicy(new SurefireTestingPolicy());
        try {
            System.setSecurityManager(new SecurityManager());
            Subject.doAs(NOEXEC, () -> {
                this.distExecTest();
                return null;
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }

    static class SimpleCallable
    implements Callable<Integer>,
    Serializable,
    ExternalPojo {
        private static final long serialVersionUID = -8589149500259272402L;

        @Override
        public Integer call() throws Exception {
            return 1;
        }
    }
}

