/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.security;

import java.security.Policy;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import javax.security.auth.Subject;
import org.apache.lucene.search.Query;
import org.infinispan.Cache;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.Index;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.EmbeddedCacheManager;
import org.infinispan.query.CacheQuery;
import org.infinispan.query.Search;
import org.infinispan.query.SearchManager;
import org.infinispan.query.api.TestEntity;
import org.infinispan.security.AuthorizationPermission;
import org.infinispan.security.PrincipalRoleMapper;
import org.infinispan.security.SurefireTestingPolicy;
import org.infinispan.security.impl.IdentityRoleMapper;
import org.infinispan.test.SingleCacheManagerTest;
import org.infinispan.test.TestingUtil;
import org.infinispan.test.fwk.TestCacheManagerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.Test;

@Test(groups={"functional"}, testName="security.QueryAuthorizationTest")
public class QueryAuthorizationTest
extends SingleCacheManagerTest {
    Subject ADMIN = TestingUtil.makeSubject((String[])new String[]{"admin"});
    Subject QUERY = TestingUtil.makeSubject((String[])new String[]{"query"});
    Subject NOQUERY = TestingUtil.makeSubject((String[])new String[]{"noquery"});

    protected EmbeddedCacheManager createCacheManager() throws Exception {
        final ConfigurationBuilder builder = this.getDefaultStandaloneCacheConfig(true);
        builder.indexing().index(Index.LOCAL).addIndexedEntity(TestEntity.class).addProperty("default.directory_provider", "local-heap").addProperty("lucene_version", "LUCENE_CURRENT").security().authorization().enable().role("admin").role("query").role("noquery");
        return Subject.doAs(this.ADMIN, new PrivilegedAction<EmbeddedCacheManager>(){

            @Override
            public EmbeddedCacheManager run() {
                EmbeddedCacheManager ecm = TestCacheManagerFactory.createCacheManager((GlobalConfigurationBuilder)QueryAuthorizationTest.this.getSecureGlobalConfiguration(), (ConfigurationBuilder)builder);
                ecm.getCache();
                return ecm;
            }
        });
    }

    private GlobalConfigurationBuilder getSecureGlobalConfiguration() {
        GlobalConfigurationBuilder global = new GlobalConfigurationBuilder();
        global.security().authorization().enable().principalRoleMapper((PrincipalRoleMapper)new IdentityRoleMapper()).role("admin").permission(AuthorizationPermission.ALL).role("query").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE).permission(AuthorizationPermission.BULK_READ).role("noquery").permission(AuthorizationPermission.READ).permission(AuthorizationPermission.WRITE);
        return global;
    }

    protected void teardown() {
        Subject.doAs(this.ADMIN, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                QueryAuthorizationTest.super.teardown();
                return null;
            }
        });
    }

    protected void clearContent() {
        Subject.doAs(this.ADMIN, new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                QueryAuthorizationTest.this.cacheManager.getCache().clear();
                return null;
            }
        });
    }

    private void queryTest() {
        this.cache.put((Object)"jekyll", (Object)new TestEntity("Henry", "Jekyll", 1L, "dissociate identity disorder"));
        this.cache.put((Object)"hyde", (Object)new TestEntity("Edward", "Hyde", 2L, "dissociate identity disorder"));
        SearchManager sm = Search.getSearchManager((Cache)this.cache);
        Query query = sm.buildQueryBuilderForClass(TestEntity.class).get().keyword().onField("name").matching((Object)"Henry").createQuery();
        CacheQuery q = sm.getQuery(query, new Class[0]);
        AssertJUnit.assertEquals((int)1, (int)q.getResultSize());
        AssertJUnit.assertEquals(TestEntity.class, ((TestEntity)q.list().get(0)).getClass());
    }

    public void testQuery() throws Exception {
        Policy.setPolicy(new SurefireTestingPolicy());
        System.setSecurityManager(new SecurityManager());
        try {
            Subject.doAs(this.QUERY, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    QueryAuthorizationTest.this.queryTest();
                    return null;
                }
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }

    @Test(expectedExceptions={SecurityException.class})
    public void testNoQuery() throws Exception {
        Policy.setPolicy(new SurefireTestingPolicy());
        try {
            System.setSecurityManager(new SecurityManager());
            Subject.doAs(this.NOQUERY, new PrivilegedExceptionAction<Void>(){

                @Override
                public Void run() throws Exception {
                    QueryAuthorizationTest.this.queryTest();
                    return null;
                }
            });
        }
        finally {
            System.setSecurityManager(null);
            Policy.setPolicy(null);
        }
    }
}

