/**
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.infinispan.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanSinkConnector extends SinkConnector {
   private static Logger log = LoggerFactory.getLogger(InfinispanSinkConnector.class);
   private Map<String, String> configProps;

   @Override
   public String version() {
      return VersionUtil.getVersion();
   }

   @Override
   public void start(Map<String, String> map) {
      configProps = map;
   }

   @Override
   public Class<? extends Task> taskClass() {
      return InfinispanSinkTask.class;
   }

   @Override
   public List<Map<String, String>> taskConfigs(int maxTasks) {
      log.info("Setting task configurations for {} workers.", maxTasks);
      final List<Map<String, String>> configs = new ArrayList<>(maxTasks);
      for (int i = 0; i < maxTasks; ++i) {
         configs.add(configProps);
      }
      return configs;
   }

   @Override
   public void stop() {
   }

   @Override
   public ConfigDef config() {
      return InfinispanSinkConnectorConfig.conf();
   }
}
