/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.kafka;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.connect.connector.Task;
import org.apache.kafka.connect.sink.SinkConnector;
import org.infinispan.kafka.InfinispanSinkConnectorConfig;
import org.infinispan.kafka.InfinispanSinkTask;
import org.infinispan.kafka.VersionUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfinispanSinkConnector
extends SinkConnector {
    private static Logger log = LoggerFactory.getLogger(InfinispanSinkConnector.class);
    private Map<String, String> configProps;

    public String version() {
        return VersionUtil.getVersion();
    }

    public void start(Map<String, String> map) {
        this.configProps = map;
    }

    public Class<? extends Task> taskClass() {
        return InfinispanSinkTask.class;
    }

    public List<Map<String, String>> taskConfigs(int maxTasks) {
        log.info("Setting task configurations for {} workers.", (Object)maxTasks);
        ArrayList<Map<String, String>> configs = new ArrayList<Map<String, String>>(maxTasks);
        for (int i = 0; i < maxTasks; ++i) {
            configs.add(this.configProps);
        }
        return configs;
    }

    public void stop() {
    }

    public ConfigDef config() {
        return InfinispanSinkConnectorConfig.conf();
    }
}

