/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream;

import com.google.gson.Gson;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.MalformedJsonException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.infinispan.protostream.DescriptorParserException;
import org.infinispan.protostream.FileDescriptorSource;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.ProtobufParser;
import org.infinispan.protostream.RawProtoStreamReader;
import org.infinispan.protostream.RawProtoStreamWriter;
import org.infinispan.protostream.SerializationContext;
import org.infinispan.protostream.TagHandler;
import org.infinispan.protostream.WrappedMessage;
import org.infinispan.protostream.config.Configuration;
import org.infinispan.protostream.descriptors.AnnotatedDescriptor;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.EnumDescriptor;
import org.infinispan.protostream.descriptors.EnumValueDescriptor;
import org.infinispan.protostream.descriptors.FieldDescriptor;
import org.infinispan.protostream.descriptors.GenericDescriptor;
import org.infinispan.protostream.descriptors.Label;
import org.infinispan.protostream.descriptors.Type;
import org.infinispan.protostream.impl.AnnotatedDescriptorImpl;
import org.infinispan.protostream.impl.BaseMarshallerDelegate;
import org.infinispan.protostream.impl.ByteArrayOutputStreamEx;
import org.infinispan.protostream.impl.RawProtoStreamReaderImpl;
import org.infinispan.protostream.impl.RawProtoStreamWriterImpl;
import org.infinispan.protostream.impl.SerializationContextImpl;

public final class ProtobufUtil {
    private static final int BUFFER_SIZE = 512;
    private static final String RFC_3339_DATE_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    private static final Gson GSON = new Gson();
    private static final String JSON_TYPE_FIELD = "_type";
    private static final String JSON_VALUE_FIELD = "_value";
    private static final ThreadLocal<DateFormat> timestampFormat = ThreadLocal.withInitial(() -> {
        SimpleDateFormat sdf = new SimpleDateFormat(RFC_3339_DATE_FORMAT);
        GregorianCalendar calendar = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
        calendar.setGregorianChange(new Date(Long.MIN_VALUE));
        sdf.setCalendar(calendar);
        return sdf;
    });

    private ProtobufUtil() {
    }

    public static SerializationContext newSerializationContext() {
        return ProtobufUtil.newSerializationContext(Configuration.builder().build());
    }

    public static SerializationContext newSerializationContext(Configuration configuration) {
        SerializationContextImpl serializationContext = new SerializationContextImpl(configuration);
        try {
            serializationContext.registerProtoFiles(FileDescriptorSource.fromResources("org/infinispan/protostream/message-wrapping.proto"));
        }
        catch (IOException | DescriptorParserException e) {
            throw new RuntimeException("Failed to initialize serialization context", e);
        }
        serializationContext.registerMarshaller(new WrappedMessage.Marshaller());
        return serializationContext;
    }

    private static <A> void writeTo(ImmutableSerializationContext ctx, RawProtoStreamWriter out, A t) throws IOException {
        if (t == null) {
            throw new IllegalArgumentException("Object to marshall cannot be null");
        }
        BaseMarshallerDelegate<?> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(t.getClass());
        marshallerDelegate.marshall(null, t, null, out);
        out.flush();
    }

    public static void writeTo(ImmutableSerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.writeTo(ctx, RawProtoStreamWriterImpl.newInstance(out), t);
    }

    public static byte[] toByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.toByteArray();
    }

    public static ByteBuffer toByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx(512);
        ProtobufUtil.writeTo(ctx, baos, t);
        return baos.getByteBuffer();
    }

    private static <A> A readFrom(ImmutableSerializationContext ctx, RawProtoStreamReader in, Class<A> clazz) throws IOException {
        BaseMarshallerDelegate<A> marshallerDelegate = ((SerializationContextImpl)ctx).getMarshallerDelegate(clazz);
        return marshallerDelegate.unmarshall(null, null, in);
    }

    public static <A> A readFrom(ImmutableSerializationContext ctx, InputStream in, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(in), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes), clazz);
    }

    public static <A> A fromByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(bytes, offset, length), clazz);
    }

    public static <A> A fromByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer, Class<A> clazz) throws IOException {
        return ProtobufUtil.readFrom(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer), clazz);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.fromWrappedByteArray(ctx, bytes, 0, bytes.length);
    }

    public static <A> A fromWrappedByteArray(ImmutableSerializationContext ctx, byte[] bytes, int offset, int length) throws IOException {
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(bytes, offset, length));
    }

    public static <A> A fromWrappedByteBuffer(ImmutableSerializationContext ctx, ByteBuffer byteBuffer) throws IOException {
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(byteBuffer));
    }

    public static <A> A fromWrappedStream(ImmutableSerializationContext ctx, InputStream in) throws IOException {
        return (A)WrappedMessage.readMessage(ctx, RawProtoStreamReaderImpl.newInstance(in));
    }

    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, Object t) throws IOException {
        return ProtobufUtil.toWrappedByteArray(ctx, t, 512);
    }

    public static byte[] toWrappedByteArray(ImmutableSerializationContext ctx, Object t, int bufferSize) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(bufferSize);
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.toByteArray();
    }

    public static ByteBuffer toWrappedByteBuffer(ImmutableSerializationContext ctx, Object t) throws IOException {
        ByteArrayOutputStreamEx baos = new ByteArrayOutputStreamEx(512);
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(baos), t);
        return baos.getByteBuffer();
    }

    public static void toWrappedStream(ImmutableSerializationContext ctx, OutputStream out, Object t) throws IOException {
        ProtobufUtil.toWrappedStream(ctx, out, t, 4096);
    }

    public static void toWrappedStream(ImmutableSerializationContext ctx, OutputStream out, Object t, int bufferSize) throws IOException {
        WrappedMessage.writeMessage(ctx, RawProtoStreamWriterImpl.newInstance(out, bufferSize), t);
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes) throws IOException {
        return ProtobufUtil.toCanonicalJSON(ctx, bytes, true);
    }

    public static byte[] fromCanonicalJSON(ImmutableSerializationContext ctx, Reader reader) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        RawProtoStreamWriter writer = RawProtoStreamWriterImpl.newInstance(baos);
        JsonReader jsonReader = new JsonReader(reader);
        jsonReader.setLenient(false);
        try {
            JsonToken token = jsonReader.peek();
            block10: while (jsonReader.hasNext() && !token.equals((Object)JsonToken.END_DOCUMENT)) {
                token = jsonReader.peek();
                switch (token) {
                    case BEGIN_OBJECT: {
                        ProtobufUtil.processJsonDocument(ctx, jsonReader, writer);
                        continue block10;
                    }
                    case NULL: {
                        jsonReader.nextNull();
                        continue block10;
                    }
                    case END_DOCUMENT: {
                        continue block10;
                    }
                }
                throw new IllegalStateException("Invalid top level object! Found token: " + token);
            }
            writer.flush();
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (MalformedJsonException e) {
            throw new IllegalStateException("Invalid JSON", e);
        }
        finally {
            baos.close();
            reader.close();
        }
    }

    private static void writeEnumField(JsonReader reader, RawProtoStreamWriter writer, FieldDescriptor fd) throws IOException {
        String value = reader.nextString();
        EnumDescriptor enumDescriptor = fd.getEnumType();
        EnumValueDescriptor valueDescriptor = enumDescriptor.findValueByName(value);
        if (valueDescriptor == null) {
            throw new IllegalStateException("Invalid enum value '" + value + "'");
        }
        int choice = valueDescriptor.getNumber();
        writer.writeEnum(fd.getNumber(), choice);
    }

    private static void writeField(JsonReader reader, RawProtoStreamWriter writer, Type fieldType, int fieldId) throws IOException {
        switch (fieldType) {
            case DOUBLE: {
                writer.writeDouble(fieldId, reader.nextDouble());
                break;
            }
            case FLOAT: {
                writer.writeFloat(fieldId, Float.parseFloat(reader.nextString()));
                break;
            }
            case INT64: {
                writer.writeInt64(fieldId, reader.nextLong());
                break;
            }
            case UINT64: {
                writer.writeUInt64(fieldId, reader.nextLong());
                break;
            }
            case FIXED64: {
                writer.writeFixed64(fieldId, reader.nextLong());
                break;
            }
            case SFIXED64: {
                writer.writeSFixed64(fieldId, reader.nextLong());
                break;
            }
            case SINT64: {
                writer.writeSInt64(fieldId, reader.nextLong());
                break;
            }
            case INT32: {
                writer.writeInt32(fieldId, reader.nextInt());
                break;
            }
            case FIXED32: {
                writer.writeFixed32(fieldId, reader.nextInt());
                break;
            }
            case UINT32: {
                writer.writeUInt32(fieldId, reader.nextInt());
                break;
            }
            case SFIXED32: {
                writer.writeSFixed32(fieldId, reader.nextInt());
                break;
            }
            case SINT32: {
                writer.writeSInt32(fieldId, reader.nextInt());
                break;
            }
            case BOOL: {
                writer.writeBool(fieldId, reader.nextBoolean());
                break;
            }
            case STRING: {
                writer.writeString(fieldId, reader.nextString());
                break;
            }
            case BYTES: {
                byte[] decoded = Base64.getDecoder().decode(reader.nextString());
                writer.writeBytes(fieldId, decoded);
                break;
            }
            default: {
                throw new IllegalArgumentException("The Protobuf declared field type is not compatible with the written type : " + (Object)((Object)fieldType));
            }
        }
    }

    private static void expectField(String expected, String value) {
        if (value == null || !value.equals(expected)) {
            throw new IllegalStateException("The document should contain a top level field '" + expected + "'");
        }
    }

    private static void expectField(FieldDescriptor descriptor, String fieldName) {
        if (descriptor == null) {
            throw new IllegalStateException("The field '" + fieldName + "' was not found in the Protobuf schema");
        }
    }

    private static void processJsonDocument(ImmutableSerializationContext ctx, JsonReader reader, RawProtoStreamWriter writer) throws IOException {
        reader.beginObject();
        JsonToken token = reader.peek();
        while (reader.hasNext() && token != JsonToken.END_DOCUMENT) {
            token = reader.peek();
            block0 : switch (token) {
                case NAME: {
                    String currentField = reader.nextName();
                    ProtobufUtil.expectField(JSON_TYPE_FIELD, currentField);
                    break;
                }
                case STRING: {
                    String topLevelType = reader.nextString();
                    Type fieldType = ProtobufUtil.getFieldType(ctx, topLevelType);
                    switch (fieldType) {
                        case ENUM: {
                            ProtobufUtil.processEnum(reader, writer, (EnumDescriptor)ctx.getDescriptorByName(topLevelType));
                            break block0;
                        }
                        case MESSAGE: {
                            ProtobufUtil.processObject(ctx, reader, writer, topLevelType, null, true);
                            break block0;
                        }
                    }
                    ProtobufUtil.processPrimitive(reader, writer, fieldType);
                }
            }
        }
    }

    private static void processEnum(JsonReader reader, RawProtoStreamWriter writer, EnumDescriptor enumDescriptor) throws IOException {
        block7: while (reader.hasNext()) {
            JsonToken token = reader.peek();
            switch (token) {
                case NAME: {
                    String fieldName = reader.nextName();
                    ProtobufUtil.expectField(JSON_VALUE_FIELD, fieldName);
                    continue block7;
                }
                case STRING: {
                    String read = reader.nextString();
                    EnumValueDescriptor valueByName = enumDescriptor.findValueByName(read);
                    if (valueByName == null) {
                        throw new IllegalStateException("Invalid enum value '" + read + "'");
                    }
                    int choice = valueByName.getNumber();
                    Integer typeId = enumDescriptor.getTypeId();
                    writer.writeInt32(19, typeId);
                    writer.writeEnum(18, choice);
                    continue block7;
                }
                case NULL: {
                    reader.nextNull();
                    throw new IllegalStateException("Invalid enum value 'null'");
                }
                case BOOLEAN: {
                    boolean bool = reader.nextBoolean();
                    throw new IllegalStateException("Invalid enum value '" + bool + "'");
                }
                case NUMBER: {
                    long number = reader.nextLong();
                    throw new IllegalStateException("Invalid enum value '" + number + "'");
                }
            }
            throw new IllegalStateException("Unexpected token :" + token);
        }
    }

    private static void processObject(ImmutableSerializationContext ctx, JsonReader reader, RawProtoStreamWriter writer, String type, Integer typeId, boolean topLevel) throws IOException {
        GenericDescriptor descriptorByName = ctx.getDescriptorByName(type);
        Descriptor messageDescriptor = (Descriptor)descriptorByName;
        Set requiredFields = messageDescriptor.getFields().stream().filter(FieldDescriptor::isRequired).map(AnnotatedDescriptorImpl::getName).collect(Collectors.toSet());
        ByteArrayOutputStream baos = new ByteArrayOutputStream(512);
        RawProtoStreamWriter objectWriter = RawProtoStreamWriterImpl.newInstance(baos);
        String currentField = null;
        while (reader.hasNext()) {
            JsonToken token = reader.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    ProtobufUtil.processArray(ctx, type, currentField, reader, objectWriter);
                    break;
                }
                case BEGIN_OBJECT: {
                    reader.beginObject();
                    FieldDescriptor descriptor = ((Descriptor)descriptorByName).findFieldByName(currentField);
                    Descriptor messageType = descriptor.getMessageType();
                    if (messageType == null) {
                        throw new IllegalStateException("Field '" + currentField + "' is not an object");
                    }
                    ProtobufUtil.processObject(ctx, reader, objectWriter, messageType.getFullName(), descriptor.getNumber(), false);
                    requiredFields.remove(descriptor.getName());
                    break;
                }
                case NAME: {
                    currentField = reader.nextName();
                    break;
                }
                case STRING: 
                case BOOLEAN: 
                case NUMBER: {
                    FieldDescriptor fieldByName = ((Descriptor)descriptorByName).findFieldByName(currentField);
                    ProtobufUtil.expectField(fieldByName, currentField);
                    if (fieldByName.getType() == Type.ENUM) {
                        ProtobufUtil.writeEnumField(reader, objectWriter, fieldByName);
                    } else {
                        ProtobufUtil.writeField(reader, objectWriter, fieldByName.getType(), fieldByName.getNumber());
                    }
                    requiredFields.remove(fieldByName.getName());
                    break;
                }
                case NULL: {
                    reader.nextNull();
                }
            }
        }
        if (!requiredFields.isEmpty()) {
            String missing = (String)requiredFields.iterator().next();
            throw new IllegalStateException("Required field '" + missing + "' missing");
        }
        if (topLevel) {
            Integer tlt = descriptorByName.getTypeId();
            if (tlt == null) {
                writer.writeString(16, type);
            } else {
                writer.writeInt32(19, tlt);
            }
            objectWriter.flush();
            writer.writeBytes(17, baos.toByteArray());
        } else {
            objectWriter.flush();
            writer.writeBytes((int)typeId, baos.toByteArray());
        }
        writer.flush();
        reader.endObject();
    }

    private static void processPrimitive(JsonReader reader, RawProtoStreamWriter writer, Type fieldType) throws IOException {
        block5: while (reader.hasNext()) {
            JsonToken token = reader.peek();
            switch (token) {
                case NAME: {
                    String fieldName = reader.nextName();
                    ProtobufUtil.expectField(JSON_VALUE_FIELD, fieldName);
                    continue block5;
                }
                case STRING: 
                case BOOLEAN: 
                case NUMBER: {
                    ProtobufUtil.writeField(reader, writer, fieldType, ProtobufUtil.getPrimitiveFieldId(fieldType));
                    continue block5;
                }
                case NULL: {
                    reader.nextNull();
                    continue block5;
                }
            }
            throw new IllegalStateException("Unexpected token :" + token);
        }
    }

    private static int getPrimitiveFieldId(Type primitiveType) {
        switch (primitiveType) {
            case DOUBLE: {
                return 1;
            }
            case FLOAT: {
                return 2;
            }
            case INT32: {
                return 5;
            }
            case INT64: {
                return 3;
            }
            case FIXED32: {
                return 7;
            }
            case FIXED64: {
                return 6;
            }
            case BOOL: {
                return 8;
            }
            case STRING: {
                return 9;
            }
            case BYTES: {
                return 10;
            }
            case UINT32: {
                return 11;
            }
            case UINT64: {
                return 4;
            }
            case SFIXED32: {
                return 12;
            }
            case SFIXED64: {
                return 13;
            }
            case SINT32: {
                return 14;
            }
            case SINT64: {
                return 15;
            }
        }
        throw new IllegalStateException("Unknown field type " + (Object)((Object)primitiveType));
    }

    private static Type getFieldType(ImmutableSerializationContext ctx, String fullTypeName) {
        switch (fullTypeName) {
            case "double": {
                return Type.DOUBLE;
            }
            case "float": {
                return Type.FLOAT;
            }
            case "int32": {
                return Type.INT32;
            }
            case "int64": {
                return Type.INT64;
            }
            case "fixed32": {
                return Type.FIXED32;
            }
            case "fixed64": {
                return Type.FIXED64;
            }
            case "bool": {
                return Type.BOOL;
            }
            case "string": {
                return Type.STRING;
            }
            case "bytes": {
                return Type.BYTES;
            }
            case "uint32": {
                return Type.UINT32;
            }
            case "uint64": {
                return Type.UINT64;
            }
            case "sfixed32": {
                return Type.SFIXED32;
            }
            case "sfixed64": {
                return Type.SFIXED64;
            }
            case "sint32": {
                return Type.SINT32;
            }
            case "sint64": {
                return Type.SINT64;
            }
        }
        GenericDescriptor descriptorByName = ctx.getDescriptorByName(fullTypeName);
        if (descriptorByName instanceof EnumDescriptor) {
            return Type.ENUM;
        }
        return Type.MESSAGE;
    }

    private static void processArray(ImmutableSerializationContext ctx, String type, String field, JsonReader reader, RawProtoStreamWriter writer) throws IOException {
        reader.beginArray();
        while (reader.hasNext()) {
            JsonToken token = reader.peek();
            switch (token) {
                case BEGIN_ARRAY: {
                    ProtobufUtil.processArray(ctx, type, field, reader, writer);
                }
                case BEGIN_OBJECT: {
                    reader.beginObject();
                    Descriptor d = (Descriptor)ctx.getDescriptorByName(type);
                    FieldDescriptor fieldByName = d.findFieldByName(field);
                    int number = fieldByName.getNumber();
                    ProtobufUtil.processObject(ctx, reader, writer, fieldByName.getMessageType().getFullName(), number, false);
                    break;
                }
                case STRING: 
                case BOOLEAN: 
                case NUMBER: {
                    Descriptor de = (Descriptor)ctx.getDescriptorByName(type);
                    FieldDescriptor fd = de.findFieldByName(field);
                    Type fieldType = fd.getType();
                    if (!fd.isRepeated()) {
                        throw new IllegalStateException("Field '" + fd.getName() + "' is not an array");
                    }
                    if (fieldType == Type.ENUM) {
                        ProtobufUtil.writeEnumField(reader, writer, fd);
                        break;
                    }
                    ProtobufUtil.writeField(reader, writer, fieldType, fd.getNumber());
                }
            }
        }
        reader.endArray();
    }

    public static String toCanonicalJSON(ImmutableSerializationContext ctx, byte[] bytes, boolean prettyPrint) throws IOException {
        StringBuilder jsonOut = new StringBuilder();
        ProtobufUtil.toCanonicalJSON(ctx, bytes, jsonOut, prettyPrint ? 0 : -1);
        return jsonOut.toString();
    }

    private static void toCanonicalJSON(final ImmutableSerializationContext ctx, byte[] bytes, final StringBuilder jsonOut, final int initNestingLevel) throws IOException {
        if (bytes.length == 0) {
            jsonOut.append("null");
            return;
        }
        final Descriptor wrapperDescriptor = ctx.getMessageDescriptor("org.infinispan.protostream.WrappedMessage");
        final boolean prettyPrint = initNestingLevel >= 0;
        final TagHandler messageHandler = new TagHandler(){
            private JsonNestingLevel nestingLevel;
            private boolean missingType = true;

            private void indent() {
                jsonOut.append('\n');
                for (int k = initNestingLevel + this.nestingLevel.indent; k > 0; --k) {
                    jsonOut.append("   ");
                }
            }

            @Override
            public void onStart(GenericDescriptor descriptor) {
                this.nestingLevel = new JsonNestingLevel(null);
                if (prettyPrint) {
                    this.indent();
                    ++this.nestingLevel.indent;
                }
                jsonOut.append('{');
                this.writeType(descriptor);
            }

            private void writeType(AnnotatedDescriptor descriptor) {
                if (descriptor != null && this.nestingLevel.previous == null && this.nestingLevel.isFirstField) {
                    this.missingType = false;
                    this.nestingLevel.isFirstField = false;
                    if (prettyPrint) {
                        this.indent();
                    }
                    jsonOut.append('\"').append(ProtobufUtil.JSON_TYPE_FIELD).append('\"').append(':');
                    if (prettyPrint) {
                        jsonOut.append(' ');
                    }
                    String type = descriptor instanceof FieldDescriptor ? ((FieldDescriptor)FieldDescriptor.class.cast(descriptor)).getTypeName() : descriptor.getFullName();
                    jsonOut.append('\"').append(type).append('\"');
                }
            }

            private String escape(String tagValue) {
                return GSON.toJson((Object)tagValue);
            }

            @Override
            public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
                if (fieldDescriptor == null) {
                    return;
                }
                if (this.missingType) {
                    this.writeType(fieldDescriptor);
                }
                this.startSlot(fieldDescriptor);
                switch (fieldDescriptor.getType()) {
                    case STRING: {
                        jsonOut.append(this.escape((String)tagValue));
                        break;
                    }
                    case INT64: 
                    case UINT64: 
                    case FIXED64: 
                    case SINT64: {
                        jsonOut.append('\"').append(tagValue).append('\"');
                        break;
                    }
                    case FLOAT: {
                        Float f = (Float)tagValue;
                        if (f.isInfinite() || f.isNaN()) {
                            jsonOut.append('\"').append(f).append('\"');
                            break;
                        }
                        jsonOut.append(f);
                        break;
                    }
                    case DOUBLE: {
                        Double d = (Double)tagValue;
                        if (d.isInfinite() || d.isNaN()) {
                            jsonOut.append('\"').append(d).append('\"');
                            break;
                        }
                        jsonOut.append(d);
                        break;
                    }
                    case ENUM: {
                        EnumValueDescriptor enumValue = fieldDescriptor.getEnumType().findValueByNumber((Integer)tagValue);
                        jsonOut.append('\"').append(enumValue.getName()).append('\"');
                        break;
                    }
                    case BYTES: {
                        String base64encoded = Base64.getEncoder().encodeToString((byte[])tagValue);
                        jsonOut.append('\"').append(base64encoded).append('\"');
                        break;
                    }
                    default: {
                        if (tagValue instanceof Date) {
                            jsonOut.append('\"').append(ProtobufUtil.formatDate((Date)tagValue)).append('\"');
                            break;
                        }
                        if (fieldNumber == 18) {
                            jsonOut.append('\"').append(tagValue).append('\"');
                            break;
                        }
                        jsonOut.append(tagValue);
                    }
                }
            }

            @Override
            public void onStartNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
                if (fieldDescriptor == null) {
                    return;
                }
                this.startSlot(fieldDescriptor);
                this.nestingLevel = new JsonNestingLevel(this.nestingLevel);
                if (prettyPrint) {
                    this.indent();
                    ++this.nestingLevel.indent;
                }
                jsonOut.append('{');
            }

            @Override
            public void onEndNested(int fieldNumber, FieldDescriptor fieldDescriptor) {
                if (this.nestingLevel.repeatedFieldDescriptor != null) {
                    this.endArraySlot();
                }
                if (prettyPrint) {
                    --this.nestingLevel.indent;
                    this.indent();
                }
                jsonOut.append('}');
                this.nestingLevel = this.nestingLevel.previous;
            }

            @Override
            public void onEnd() {
                if (this.nestingLevel.repeatedFieldDescriptor != null) {
                    this.endArraySlot();
                }
                if (prettyPrint) {
                    --this.nestingLevel.indent;
                    this.indent();
                }
                jsonOut.append('}');
                this.nestingLevel = null;
                if (prettyPrint) {
                    jsonOut.append('\n');
                }
            }

            private void startSlot(FieldDescriptor fieldDescriptor) {
                if (this.nestingLevel.repeatedFieldDescriptor != null && this.nestingLevel.repeatedFieldDescriptor != fieldDescriptor) {
                    this.endArraySlot();
                }
                if (this.nestingLevel.isFirstField) {
                    this.nestingLevel.isFirstField = false;
                } else {
                    jsonOut.append(',');
                }
                if (!fieldDescriptor.isRepeated() || this.nestingLevel.repeatedFieldDescriptor == null) {
                    if (prettyPrint) {
                        this.indent();
                    }
                    if (fieldDescriptor.getLabel() == Label.ONE_OF) {
                        jsonOut.append('\"').append(ProtobufUtil.JSON_VALUE_FIELD).append("\":");
                    } else {
                        jsonOut.append('\"').append(fieldDescriptor.getName()).append("\":");
                    }
                }
                if (prettyPrint) {
                    jsonOut.append(' ');
                }
                if (fieldDescriptor.isRepeated() && this.nestingLevel.repeatedFieldDescriptor == null) {
                    this.nestingLevel.repeatedFieldDescriptor = fieldDescriptor;
                    jsonOut.append('[');
                }
            }

            private void endArraySlot() {
                if (prettyPrint && this.nestingLevel.repeatedFieldDescriptor.getType() == Type.MESSAGE) {
                    this.indent();
                }
                this.nestingLevel.repeatedFieldDescriptor = null;
                jsonOut.append(']');
            }
        };
        TagHandler wrapperHandler = new TagHandler(){
            private Integer typeId;
            private String typeName;
            private byte[] wrappedMessage;
            private Integer wrappedEnum;

            private GenericDescriptor getDescriptor() {
                return this.typeId != null ? ctx.getDescriptorByTypeId(this.typeId) : ctx.getDescriptorByName(this.typeName);
            }

            @Override
            public void onTag(int fieldNumber, FieldDescriptor fieldDescriptor, Object tagValue) {
                if (fieldDescriptor == null) {
                    return;
                }
                switch (fieldNumber) {
                    case 19: {
                        this.typeId = (Integer)tagValue;
                        break;
                    }
                    case 16: {
                        this.typeName = (String)tagValue;
                        break;
                    }
                    case 17: {
                        this.wrappedMessage = (byte[])tagValue;
                        break;
                    }
                    case 18: {
                        this.wrappedEnum = (Integer)tagValue;
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: 
                    case 4: 
                    case 5: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 12: 
                    case 13: 
                    case 14: 
                    case 15: {
                        messageHandler.onStart(null);
                        messageHandler.onTag(fieldNumber, fieldDescriptor, tagValue);
                        messageHandler.onEnd();
                    }
                }
            }

            @Override
            public void onEnd() {
                if (this.wrappedEnum != null) {
                    EnumDescriptor enumDescriptor = (EnumDescriptor)this.getDescriptor();
                    String enumConstantName = enumDescriptor.findValueByNumber(this.wrappedEnum).getName();
                    FieldDescriptor fd = wrapperDescriptor.findFieldByNumber(18);
                    messageHandler.onStart(enumDescriptor);
                    messageHandler.onTag(18, fd, enumConstantName);
                    messageHandler.onEnd();
                } else if (this.wrappedMessage != null) {
                    try {
                        Descriptor messageDescriptor = (Descriptor)this.getDescriptor();
                        ProtobufParser.INSTANCE.parse(messageHandler, messageDescriptor, this.wrappedMessage);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        };
        ProtobufParser.INSTANCE.parse(wrapperHandler, wrapperDescriptor, bytes);
    }

    private static String formatDate(Date tagValue) {
        return timestampFormat.get().format(tagValue);
    }

    private static final class JsonNestingLevel {
        boolean isFirstField = true;
        FieldDescriptor repeatedFieldDescriptor;
        int indent;
        JsonNestingLevel previous;

        JsonNestingLevel(JsonNestingLevel previous) {
            this.previous = previous;
            this.indent = previous != null ? previous.indent + 1 : 0;
        }
    }
}

