/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.annotations.impl;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.infinispan.protostream.annotations.ProtoEnum;
import org.infinispan.protostream.annotations.ProtoEnumValue;
import org.infinispan.protostream.annotations.ProtoName;
import org.infinispan.protostream.annotations.ProtoSchemaBuilderException;
import org.infinispan.protostream.annotations.impl.BaseProtoSchemaGenerator;
import org.infinispan.protostream.annotations.impl.IndentWriter;
import org.infinispan.protostream.annotations.impl.ProtoEnumValueMetadata;
import org.infinispan.protostream.annotations.impl.ProtoTypeMetadata;
import org.infinispan.protostream.annotations.impl.ReservedProcessor;
import org.infinispan.protostream.annotations.impl.types.XClass;
import org.infinispan.protostream.annotations.impl.types.XEnumConstant;
import org.infinispan.protostream.impl.Log;

public final class ProtoEnumTypeMetadata
extends ProtoTypeMetadata {
    private static final Log log = Log.LogFactory.getLog(ProtoEnumTypeMetadata.class);
    private final XClass annotatedEnumClass;
    private final boolean isAdapter;
    private SortedMap<Integer, ProtoEnumValueMetadata> membersByNumber;
    private Map<String, ProtoEnumValueMetadata> membersByName;

    public ProtoEnumTypeMetadata(XClass annotatedEnumClass, XClass enumClass) {
        super(ProtoEnumTypeMetadata.getProtoName(annotatedEnumClass, enumClass), enumClass);
        this.annotatedEnumClass = annotatedEnumClass;
        this.isAdapter = annotatedEnumClass != enumClass;
    }

    private static String getProtoName(XClass annotatedEnumClass, XClass enumClass) {
        ProtoName annotation = annotatedEnumClass.getAnnotation(ProtoName.class);
        ProtoEnum protoEnumAnnotation = annotatedEnumClass.getAnnotation(ProtoEnum.class);
        if (annotation != null) {
            if (protoEnumAnnotation != null) {
                throw new ProtoSchemaBuilderException("@ProtoEnum annotation cannot be used together with @ProtoName: " + annotatedEnumClass.getName());
            }
            return annotation.value().isEmpty() ? enumClass.getSimpleName() : annotation.value();
        }
        return protoEnumAnnotation == null || protoEnumAnnotation.name().isEmpty() ? enumClass.getSimpleName() : protoEnumAnnotation.name();
    }

    @Override
    public XClass getAnnotatedClass() {
        return this.annotatedEnumClass;
    }

    @Override
    public boolean isAdapter() {
        return this.isAdapter;
    }

    @Override
    public void scanMemberAnnotations() {
        if (this.membersByNumber == null) {
            this.membersByNumber = new TreeMap<Integer, ProtoEnumValueMetadata>();
            this.membersByName = new HashMap<String, ProtoEnumValueMetadata>();
            for (XEnumConstant xEnumConstant : this.annotatedEnumClass.getEnumConstants()) {
                ProtoEnumValue annotation = xEnumConstant.getAnnotation(ProtoEnumValue.class);
                if (annotation == null) {
                    throw new ProtoSchemaBuilderException("Enum constants must have the @ProtoEnumValue annotation: " + this.getAnnotatedClassName() + '.' + xEnumConstant.getName());
                }
                int number = this.getNumber(annotation, xEnumConstant);
                if (this.membersByNumber.containsKey(number)) {
                    throw new ProtoSchemaBuilderException("Found duplicate definition of Protobuf enum tag " + number + " on enum constant: " + this.getAnnotatedClassName() + '.' + xEnumConstant.getName());
                }
                String name = annotation.name();
                if (name.isEmpty()) {
                    name = xEnumConstant.getName();
                }
                if (this.membersByName.containsKey(name)) {
                    throw new ProtoSchemaBuilderException("Found duplicate definition of Protobuf enum constant " + name + " on enum constant: " + this.getAnnotatedClassName() + '.' + xEnumConstant.getName());
                }
                ProtoEnumValueMetadata pevm = new ProtoEnumValueMetadata(number, name, xEnumConstant.getOrdinal(), this.getJavaClassName() + '.' + xEnumConstant.getName(), xEnumConstant.getProtoDocs());
                this.membersByNumber.put(number, pevm);
                this.membersByName.put(pevm.getProtoName(), pevm);
            }
            if (this.membersByNumber.isEmpty()) {
                throw new ProtoSchemaBuilderException("Enums without members are not allowed: " + this.getAnnotatedClassName());
            }
        }
    }

    private int getNumber(ProtoEnumValue annotation, XEnumConstant ec) {
        int number = annotation.number();
        if (number == 0) {
            number = annotation.value();
        } else if (annotation.value() != 0) {
            throw new ProtoSchemaBuilderException("@ProtoEnumValue.number() and value() are mutually exclusive: " + this.getAnnotatedClassName() + '.' + ec.getName());
        }
        return number;
    }

    public SortedMap<Integer, ProtoEnumValueMetadata> getMembers() {
        this.scanMemberAnnotations();
        return this.membersByNumber;
    }

    @Override
    public boolean isEnum() {
        return true;
    }

    @Override
    public ProtoEnumValueMetadata getEnumMemberByName(String name) {
        this.scanMemberAnnotations();
        return this.membersByName.get(name);
    }

    @Override
    public void generateProto(IndentWriter iw) {
        XClass where;
        this.scanMemberAnnotations();
        iw.append("\n\n");
        ProtoEnumTypeMetadata.appendDocumentation(iw, this.getDocumentation());
        iw.append("enum ").append(this.name);
        if (BaseProtoSchemaGenerator.generateSchemaDebugComments) {
            iw.append(" /* ").append(this.getJavaClassName()).append(" */");
        }
        iw.append(" {\n");
        iw.inc();
        ReservedProcessor reserved = new ReservedProcessor();
        reserved.scan(this.annotatedEnumClass);
        for (String memberName : this.membersByName.keySet()) {
            where = reserved.checkReserved(this.name);
            if (where == null) continue;
            throw new ProtoSchemaBuilderException("Protobuf enum value " + memberName + " of enum constant " + this.membersByName.get(memberName).getJavaEnumName() + " conflicts with 'reserved' statement in " + where.getCanonicalName());
        }
        Iterator<Object> iterator = this.membersByNumber.keySet().iterator();
        while (iterator.hasNext()) {
            int memberNumber = (Integer)iterator.next();
            where = reserved.checkReserved(memberNumber);
            if (where == null) continue;
            throw new ProtoSchemaBuilderException("Protobuf enum number " + memberNumber + " of enum constant " + ((ProtoEnumValueMetadata)this.membersByNumber.get(memberNumber)).getJavaEnumName() + " conflicts with 'reserved' statement in " + where.getCanonicalName());
        }
        reserved.generate(iw);
        for (ProtoEnumValueMetadata m : this.membersByNumber.values()) {
            m.generateProto(iw);
        }
        iw.dec();
        iw.append("}\n");
    }

    public String toString() {
        return "ProtoEnumTypeMetadata{name='" + this.name + '\'' + ", javaClass=" + this.javaClass + ", annotatedEnumClass=" + this.annotatedEnumClass + ", isAdapter=" + this.isAdapter + ", membersByNumber=" + this.membersByNumber + '}';
    }
}

