/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.protostream.impl;

import com.google.protobuf.CodedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.infinispan.protostream.RawProtoStreamWriter;

public final class RawProtoStreamWriterImpl
implements RawProtoStreamWriter {
    private final CodedOutputStream delegate;

    private RawProtoStreamWriterImpl(CodedOutputStream delegate) {
        this.delegate = delegate;
    }

    public static RawProtoStreamWriter newInstance(OutputStream output) {
        return new RawProtoStreamWriterImpl(CodedOutputStream.newInstance((OutputStream)output));
    }

    public static RawProtoStreamWriter newInstance(OutputStream output, int bufferSize) {
        return new RawProtoStreamWriterImpl(CodedOutputStream.newInstance((OutputStream)output, (int)bufferSize));
    }

    public static RawProtoStreamWriter newInstance(byte[] flatArray) {
        return new RawProtoStreamWriterImpl(CodedOutputStream.newInstance((byte[])flatArray));
    }

    public static RawProtoStreamWriter newInstance(byte[] flatArray, int offset, int length) {
        return new RawProtoStreamWriterImpl(CodedOutputStream.newInstance((byte[])flatArray, (int)offset, (int)length));
    }

    public static RawProtoStreamWriter newInstance(ByteBuffer byteBuffer) {
        return new RawProtoStreamWriterImpl(CodedOutputStream.newInstance((ByteBuffer)byteBuffer));
    }

    public CodedOutputStream getDelegate() {
        return this.delegate;
    }

    @Override
    public void writeTag(int number, int wireType) throws IOException {
        this.delegate.writeTag(number, wireType);
    }

    @Override
    public void writeUInt32NoTag(int value) throws IOException {
        this.delegate.writeUInt32NoTag(value);
    }

    @Override
    public void writeUInt64NoTag(long value) throws IOException {
        this.delegate.writeUInt64NoTag(value);
    }

    @Override
    public void writeString(int number, String value) throws IOException {
        this.delegate.writeString(number, value);
    }

    @Override
    public void writeInt32(int number, int value) throws IOException {
        this.delegate.writeInt32(number, value);
    }

    @Override
    public void writeInt64(int number, long value) throws IOException {
        this.delegate.writeInt64(number, value);
    }

    @Override
    public void writeFixed32(int number, int value) throws IOException {
        this.delegate.writeFixed32(number, value);
    }

    @Override
    public void writeUInt32(int number, int value) throws IOException {
        this.delegate.writeUInt32(number, value);
    }

    @Override
    public void writeSFixed32(int number, int value) throws IOException {
        this.delegate.writeSFixed32(number, value);
    }

    @Override
    public void writeSInt32(int number, int value) throws IOException {
        this.delegate.writeSInt32(number, value);
    }

    @Override
    public void writeEnum(int number, int value) throws IOException {
        this.delegate.writeEnum(number, value);
    }

    @Override
    public void flush() throws IOException {
        this.delegate.flush();
    }

    @Override
    public void writeBool(int number, boolean value) throws IOException {
        this.delegate.writeBool(number, value);
    }

    @Override
    public void writeDouble(int number, double value) throws IOException {
        this.delegate.writeDouble(number, value);
    }

    @Override
    public void writeFloat(int number, float value) throws IOException {
        this.delegate.writeFloat(number, value);
    }

    @Override
    public void writeBytes(int number, ByteBuffer value) throws IOException {
        int off = value.arrayOffset();
        int len = value.limit() - off;
        this.delegate.writeByteArray(number, value.array(), off, len);
    }

    @Override
    public void writeBytes(int number, byte[] value) throws IOException {
        this.delegate.writeByteArray(number, value);
    }

    @Override
    public void writeBytes(int number, byte[] value, int offset, int length) throws IOException {
        this.delegate.writeByteArray(number, value, offset, length);
    }

    @Override
    public void writeUInt64(int number, long value) throws IOException {
        this.delegate.writeUInt64(number, value);
    }

    @Override
    public void writeFixed64(int number, long value) throws IOException {
        this.delegate.writeFixed64(number, value);
    }

    @Override
    public void writeSFixed64(int number, long value) throws IOException {
        this.delegate.writeSFixed64(number, value);
    }

    @Override
    public void writeSInt64(int number, long value) throws IOException {
        this.delegate.writeSInt64(number, value);
    }

    @Override
    public void writeRawBytes(byte[] value, int offset, int length) throws IOException {
        this.delegate.writeRawBytes(value, offset, length);
    }
}

