/*
 * Decompiled with CFR 0.152.
 */
package infinispan.autoconfigure;

import infinispan.autoconfigure.InfinispanCacheConfigurer;
import infinispan.autoconfigure.InfinispanGlobalConfigurer;
import infinispan.autoconfigure.InfinispanProperties;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.manager.CacheContainer;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.manager.EmbeddedCacheManager;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;

@Configuration
@ComponentScan
@ConditionalOnClass(value={CacheContainer.class})
@EnableConfigurationProperties(value={InfinispanProperties.class})
public class InfinispanAutoConfiguration {
    public static final String DEFAULT_JMX_DOMAIN = "spring.infinispan";
    @Autowired
    private InfinispanProperties infinispanProperties;
    @Autowired(required=false)
    private List<InfinispanCacheConfigurer> configurers = Collections.emptyList();
    @Autowired(required=false)
    private InfinispanGlobalConfigurer infinispanGlobalConfigurer;

    @ConditionalOnMissingBean(value={EmbeddedCacheManager.class})
    @Bean(destroyMethod="stop")
    public DefaultCacheManager defaultCacheManager() throws IOException {
        String configXml = this.infinispanProperties.getConfigXml();
        GlobalConfiguration defaultGlobalConfiguration = new GlobalConfigurationBuilder().globalJmxStatistics().jmxDomain(DEFAULT_JMX_DOMAIN).enable().transport().clusterName(this.infinispanProperties.getClusterName()).build();
        GlobalConfiguration globalConfiguration = this.infinispanGlobalConfigurer == null ? defaultGlobalConfiguration : this.infinispanGlobalConfigurer.getGlobalConfiguration();
        DefaultCacheManager manager = configXml.isEmpty() ? new DefaultCacheManager(globalConfiguration) : new DefaultCacheManager(configXml);
        this.configureCaches((EmbeddedCacheManager)manager);
        return manager;
    }

    private void configureCaches(EmbeddedCacheManager manager) {
        this.configurers.forEach(configurer -> configurer.configureCache(manager));
    }
}

