/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.resource;

import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.core.UriInfo;
import org.jberet.rest._private.RestAPIMessages;
import org.jberet.rest.entity.JobExecutionEntity;
import org.jberet.rest.entity.StepExecutionEntity;
import org.jberet.rest.resource.JobResource;
import org.jberet.rest.resource.JobService;

@Path(value="jobexecutions")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class JobExecutionResource {
    @GET
    public JobExecutionEntity[] getJobExecutions(@QueryParam(value="count") int count, @QueryParam(value="jobInstanceId") long jobInstanceId, @QueryParam(value="jobExecutionId1") long jobExecutionId1, @Context UriInfo uriInfo) {
        JobExecutionEntity[] jobExecutionEntities = JobService.getInstance().getJobExecutions(count, jobInstanceId, jobExecutionId1);
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntities);
        return jobExecutionEntities;
    }

    @Path(value="running")
    @GET
    public JobExecutionEntity[] getRunningExecutions(@QueryParam(value="jobName") String jobName, @Context UriInfo uriInfo) {
        JobExecutionEntity[] jobExecutionEntities = JobService.getInstance().getRunningExecutions(jobName);
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntities);
        return jobExecutionEntities;
    }

    @Path(value="{jobExecutionId}")
    @GET
    public JobExecutionEntity getJobExecution(@PathParam(value="jobExecutionId") long jobExecutionId, @Context UriInfo uriInfo) {
        JobExecutionEntity jobExecution = JobService.getInstance().getJobExecution(jobExecutionId);
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecution);
        return jobExecution;
    }

    @Path(value="{jobExecutionId}/abandon")
    @POST
    public void abandon(@PathParam(value="jobExecutionId") long jobExecutionId) {
        JobService.getInstance().abandon(jobExecutionId);
    }

    @Path(value="{jobExecutionId}/stop")
    @POST
    public void stop(@PathParam(value="jobExecutionId") long jobExecutionId) {
        JobService.getInstance().stop(jobExecutionId);
    }

    @Path(value="{jobExecutionId}/restart")
    @POST
    public JobExecutionEntity restart(@PathParam(value="jobExecutionId") long jobExecutionId, @Context UriInfo uriInfo, Properties jobParamsAsProps) {
        JobExecutionEntity jobExecutionEntity = JobService.getInstance().restart(jobExecutionId, JobResource.jobParametersFromUriInfoAndProps(uriInfo, jobParamsAsProps));
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntity);
        return jobExecutionEntity;
    }

    @GET
    @Path(value="{jobExecutionId}/stepexecutions")
    public StepExecutionEntity[] getStepExecutions(@PathParam(value="jobExecutionId") long jobExecutionId) {
        return JobService.getInstance().getStepExecutions(jobExecutionId);
    }

    @GET
    @Path(value="{jobExecutionId}/stepexecutions/{stepExecutionId}")
    public StepExecutionEntity getStepExecution(@PathParam(value="jobExecutionId") long jobExecutionId, @PathParam(value="stepExecutionId") long stepExecutionId) {
        StepExecutionEntity[] stepExecutionData;
        for (StepExecutionEntity e : stepExecutionData = JobService.getInstance().getStepExecutions(jobExecutionId)) {
            if (e.getStepExecutionId() != stepExecutionId) continue;
            return e;
        }
        throw RestAPIMessages.MESSAGES.notFoundException("stepExecutionId", String.valueOf(stepExecutionId));
    }

    static void setJobExecutionEntityHref(UriInfo uriInfo, JobExecutionEntity ... entities) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(JobExecutionResource.class);
        for (JobExecutionEntity e : entities) {
            e.setHref(uriBuilder.clone().path(String.valueOf(e.getExecutionId())).build(new Object[0]).toString());
        }
    }
}

