/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.resource;

import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.jberet.rest.entity.JobEntity;
import org.jberet.rest.entity.JobExecutionEntity;
import org.jberet.rest.resource.JobExecutionResource;
import org.jberet.rest.resource.JobService;

@Path(value="jobs")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class JobResource {
    @Path(value="{jobXmlName}/start")
    @POST
    public Response start(@PathParam(value="jobXmlName") String jobXmlName, @Context UriInfo uriInfo, Properties jobParamsAsProps) {
        JobExecutionEntity jobExecutionData = JobService.getInstance().start(jobXmlName, JobResource.jobParametersFromUriInfoAndProps(uriInfo, jobParamsAsProps));
        URI jobExecutionDataUri = uriInfo.getBaseUriBuilder().path(JobExecutionResource.class).path(String.valueOf(jobExecutionData.getExecutionId())).build(new Object[0]);
        jobExecutionData.setHref(jobExecutionDataUri.toString());
        return Response.created((URI)jobExecutionDataUri).entity((Object)jobExecutionData).build();
    }

    @GET
    public JobEntity[] getJobs() {
        JobEntity[] jobEntities = JobService.getInstance().getJobs();
        return jobEntities;
    }

    static Properties jobParametersFromUriInfoAndProps(UriInfo uriInfo, Properties props) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters(true);
        if (queryParameters.isEmpty()) {
            return props;
        }
        Properties p = new Properties();
        for (Map.Entry e : queryParameters.entrySet()) {
            p.setProperty((String)e.getKey(), (String)((List)e.getValue()).get(0));
        }
        if (props != null) {
            for (String k : props.stringPropertyNames()) {
                p.setProperty(k, props.getProperty(k));
            }
        }
        return p;
    }
}

