/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.client;

import java.net.URI;
import java.util.Properties;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.UriBuilder;
import org.jberet.rest.entity.JobExecutionEntity;
import org.jberet.rest.entity.JobInstanceEntity;
import org.jberet.rest.entity.StepExecutionEntity;
import org.jberet.rest.resource.JobExecutionResource;
import org.jberet.rest.resource.JobInstanceResource;
import org.jberet.rest.resource.JobResource;
import org.jberet.rest.resource.JobScheduleResource;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;

public class BatchClient {
    private final Client client;
    private final String restUrl;

    public BatchClient(String restUrl) {
        this(ClientBuilder.newClient(), restUrl);
    }

    public BatchClient(Client client, String restUrl) {
        this.client = client;
        this.restUrl = restUrl;
    }

    public Client getClient() {
        return this.client;
    }

    public String getRestUrl() {
        return this.restUrl;
    }

    public JobExecutionEntity startJob(String jobXmlName, Properties queryParams) throws Exception {
        URI uri = this.getJobUriBuilder("start").resolveTemplate("jobXmlName", (Object)jobXmlName).build(new Object[0]);
        WebTarget target = this.target(uri, queryParams);
        return (JobExecutionEntity)target.request().post(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE), JobExecutionEntity.class);
    }

    public JobExecutionEntity restartJobExecution(long jobExecutionId, Properties queryParams) throws Exception {
        URI uri = this.getJobExecutionUriBuilder("restart").resolveTemplate("jobExecutionId", (Object)jobExecutionId).build(new Object[0]);
        WebTarget target = this.target(uri, queryParams);
        return (JobExecutionEntity)target.request().post(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE), JobExecutionEntity.class);
    }

    public JobExecutionEntity restartJobExecution(String jobXmlName, Properties queryParams) throws Exception {
        URI uri = this.getJobUriBuilder("restart").resolveTemplate("jobXmlName", (Object)jobXmlName).build(new Object[0]);
        WebTarget target = this.target(uri, queryParams);
        return (JobExecutionEntity)target.request().post(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE), JobExecutionEntity.class);
    }

    public JobInstanceEntity[] getJobInstances(String jobName, int start, int count) throws Exception {
        URI uri = this.getJobInstanceUriBuilder(null).build(new Object[0]);
        WebTarget target = this.target(uri).queryParam("jobName", new Object[]{jobName}).queryParam("start", new Object[]{start}).queryParam("count", new Object[]{count});
        return (JobInstanceEntity[])target.request().get(JobInstanceEntity[].class);
    }

    public WebTarget target(URI uri) {
        return this.client.target(uri);
    }

    public WebTarget target(URI uri, Properties props) {
        WebTarget result = this.client.target(uri);
        if (props == null) {
            return result;
        }
        for (String k : props.stringPropertyNames()) {
            result = result.queryParam(k, new Object[]{props.getProperty(k)});
        }
        return result;
    }

    public JobExecutionEntity getJobExecution(long jobExecutionId) {
        URI uri = this.getJobExecutionUriBuilder(null).path(String.valueOf(jobExecutionId)).build(new Object[0]);
        WebTarget target = this.client.target(uri);
        return (JobExecutionEntity)target.request().get(JobExecutionEntity.class);
    }

    public StepExecutionEntity[] getStepExecutions(long jobExecutionId) {
        URI uri = this.getJobExecutionUriBuilder("getStepExecutions").resolveTemplate("jobExecutionId", (Object)jobExecutionId).build(new Object[0]);
        WebTarget target = this.target(uri);
        return (StepExecutionEntity[])target.request().get(StepExecutionEntity[].class);
    }

    public JobSchedule getJobSchedule(String scheduleId) {
        URI uri = this.getJobScheduleUriBuilder("getJobSchedule").resolveTemplate("scheduleId", (Object)scheduleId).build(new Object[0]);
        WebTarget target = this.target(uri);
        return (JobSchedule)target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JobSchedule.class);
    }

    public JobSchedule[] getJobSchedules() {
        URI uri = this.getJobScheduleUriBuilder("getJobSchedules").build(new Object[0]);
        WebTarget target = this.target(uri);
        return (JobSchedule[])target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(JobSchedule[].class);
    }

    public String[] getJobScheduleFeatures() {
        URI uri = this.getJobScheduleUriBuilder("getFeatures").build(new Object[0]);
        WebTarget target = this.target(uri);
        return (String[])target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).get(String[].class);
    }

    public boolean cancelJobSchedule(String scheduleId) {
        URI uri = this.getJobScheduleUriBuilder("cancel").resolveTemplate("scheduleId", (Object)scheduleId).build(new Object[0]);
        WebTarget target = this.target(uri);
        return (Boolean)target.request().accept(new MediaType[]{MediaType.APPLICATION_JSON_TYPE}).post(Entity.entity(null, (MediaType)MediaType.APPLICATION_JSON_TYPE), Boolean.TYPE);
    }

    public JobSchedule schedule(JobScheduleConfig scheduleConfig) {
        URI uri = scheduleConfig.getJobName() != null ? this.getJobUriBuilder("schedule").resolveTemplate("jobXmlName", (Object)scheduleConfig.getJobName()).build(new Object[0]) : this.getJobExecutionUriBuilder("schedule").resolveTemplate("jobExecutionId", (Object)scheduleConfig.getJobExecutionId()).build(new Object[0]);
        WebTarget target = this.target(uri);
        return (JobSchedule)target.request().post(Entity.json((Object)scheduleConfig), JobSchedule.class);
    }

    public UriBuilder getUriBuilder(Class<?> cls, String methodName) {
        UriBuilder uriBuilder = UriBuilder.fromPath((String)this.restUrl).path(cls);
        if (methodName != null) {
            uriBuilder = uriBuilder.path(cls, methodName);
        }
        return uriBuilder;
    }

    public UriBuilder getJobUriBuilder(String methodName) {
        return this.getUriBuilder(JobResource.class, methodName);
    }

    public UriBuilder getJobInstanceUriBuilder(String methodName) {
        return this.getUriBuilder(JobInstanceResource.class, methodName);
    }

    public UriBuilder getJobExecutionUriBuilder(String methodName) {
        return this.getUriBuilder(JobExecutionResource.class, methodName);
    }

    public UriBuilder getJobScheduleUriBuilder(String methodName) {
        return this.getUriBuilder(JobScheduleResource.class, methodName);
    }
}

