/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.resource;

import java.util.Arrays;
import java.util.List;
import java.util.TimeZone;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduler;

@Path(value="schedules")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class JobScheduleResource {
    @GET
    @Path(value="")
    public JobSchedule[] getJobSchedules() {
        JobScheduler jobScheduler = JobScheduler.getJobScheduler();
        List jobScheduleList = jobScheduler.getJobSchedules();
        return jobScheduleList.toArray(new JobSchedule[jobScheduleList.size()]);
    }

    @POST
    @Path(value="{scheduleId}/cancel")
    public boolean cancel(@PathParam(value="scheduleId") String scheduleId) {
        JobScheduler jobScheduler = JobScheduler.getJobScheduler();
        return jobScheduler.cancel(scheduleId);
    }

    @DELETE
    @Path(value="{scheduleId}")
    public void delete(@PathParam(value="scheduleId") String scheduleId) {
        JobScheduler jobScheduler = JobScheduler.getJobScheduler();
        jobScheduler.delete(scheduleId);
    }

    @GET
    @Path(value="{scheduleId : .*\\d+.*}")
    public JobSchedule getJobSchedule(@PathParam(value="scheduleId") String scheduleId) {
        JobScheduler jobScheduler = JobScheduler.getJobScheduler();
        return jobScheduler.getJobSchedule(scheduleId);
    }

    @GET
    @Path(value="timezones")
    public String[] getTimezoneIds() {
        Object[] availableIDs = TimeZone.getAvailableIDs();
        Arrays.sort(availableIDs);
        int i = Arrays.binarySearch(availableIDs, TimeZone.getDefault().getID());
        String[] result = new String[availableIDs.length];
        result[0] = availableIDs[i];
        System.arraycopy(availableIDs, 0, result, 1, i);
        System.arraycopy(availableIDs, i + 1, result, i + 1, availableIDs.length - (i + 1));
        return result;
    }

    @GET
    @Path(value="features")
    public String[] getFeatures() {
        return JobScheduler.getJobScheduler().getFeatures();
    }
}

