/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.UriBuilder;
import jakarta.ws.rs.core.UriInfo;
import java.util.Properties;
import org.jberet.rest._private.RestAPIMessages;
import org.jberet.rest.entity.JobExecutionEntity;
import org.jberet.rest.entity.StepExecutionEntity;
import org.jberet.rest.resource.JobResource;
import org.jberet.rest.service.JobService;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduler;

@Path(value="jobexecutions")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class JobExecutionResource {
    @GET
    public JobExecutionEntity[] getJobExecutions(@QueryParam(value="count") int count, @QueryParam(value="jobInstanceId") long jobInstanceId, @QueryParam(value="jobExecutionId1") long jobExecutionId1, @Context UriInfo uriInfo) {
        JobExecutionEntity[] jobExecutionEntities = JobService.getInstance().getJobExecutions(count, jobInstanceId, jobExecutionId1);
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntities);
        return jobExecutionEntities;
    }

    @Path(value="running")
    @GET
    public JobExecutionEntity[] getRunningExecutions(@QueryParam(value="jobName") String jobName, @Context UriInfo uriInfo) {
        JobExecutionEntity[] jobExecutionEntities = JobService.getInstance().getRunningExecutions(jobName);
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntities);
        return jobExecutionEntities;
    }

    @Path(value="{jobExecutionId : \\d+}")
    @GET
    public JobExecutionEntity getJobExecution(@PathParam(value="jobExecutionId") long jobExecutionId, @Context UriInfo uriInfo) {
        JobExecutionEntity jobExecution = JobService.getInstance().getJobExecution(jobExecutionId);
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecution);
        return jobExecution;
    }

    @Path(value="{jobExecutionId}/abandon")
    @POST
    public void abandon(@PathParam(value="jobExecutionId") long jobExecutionId) {
        JobService.getInstance().abandon(jobExecutionId);
    }

    @Path(value="{jobExecutionId}/stop")
    @POST
    public void stop(@PathParam(value="jobExecutionId") long jobExecutionId) {
        JobService.getInstance().stop(jobExecutionId);
    }

    @Path(value="{jobExecutionId}/restart")
    @POST
    public JobExecutionEntity restart(@PathParam(value="jobExecutionId") long jobExecutionId, @Context UriInfo uriInfo, Properties jobParamsAsProps) {
        JobExecutionEntity jobExecutionEntity = JobService.getInstance().restart(jobExecutionId, JobResource.jobParametersFromUriInfoAndProps(uriInfo, jobParamsAsProps));
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntity);
        return jobExecutionEntity;
    }

    @Path(value="{jobExecutionId}/resubmit")
    @POST
    public JobExecutionEntity resubmit(@PathParam(value="jobExecutionId") long jobExecutionId, @Context UriInfo uriInfo, String jobDefinition) {
        JobExecutionEntity jobExecutionEntity = JobService.getInstance().resubmit(jobDefinition, jobExecutionId, JobResource.jobParametersFromUriInfoAndProps(uriInfo, null));
        JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntity);
        return jobExecutionEntity;
    }

    @Path(value="{jobExecutionId}/schedule")
    @POST
    public JobSchedule schedule(@PathParam(value="jobExecutionId") long jobExecutionId, JobScheduleConfig scheduleConfig) {
        JobScheduler jobScheduler = JobScheduler.getJobScheduler();
        if (scheduleConfig.getJobExecutionId() == 0L) {
            scheduleConfig.setJobExecutionId(jobExecutionId);
        }
        return jobScheduler.schedule(scheduleConfig);
    }

    @GET
    @Path(value="{jobExecutionId}/stepexecutions")
    public StepExecutionEntity[] getStepExecutions(@PathParam(value="jobExecutionId") long jobExecutionId) {
        return JobService.getInstance().getStepExecutions(jobExecutionId);
    }

    @GET
    @Path(value="{jobExecutionId}/stepexecutions/{stepExecutionId}")
    public StepExecutionEntity getStepExecution(@PathParam(value="jobExecutionId") long jobExecutionId, @PathParam(value="stepExecutionId") long stepExecutionId) {
        StepExecutionEntity[] stepExecutionData;
        for (StepExecutionEntity e : stepExecutionData = JobService.getInstance().getStepExecutions(jobExecutionId)) {
            if (e.getStepExecutionId() != stepExecutionId) continue;
            return e;
        }
        throw RestAPIMessages.MESSAGES.notFoundException("stepExecutionId", String.valueOf(stepExecutionId));
    }

    static void setJobExecutionEntityHref(UriInfo uriInfo, JobExecutionEntity ... entities) {
        UriBuilder uriBuilder = uriInfo.getBaseUriBuilder().path(JobExecutionResource.class);
        for (JobExecutionEntity e : entities) {
            e.setHref(uriBuilder.clone().path(String.valueOf(e.getExecutionId())).build(new Object[0]).toString());
        }
    }
}

