/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.core.Response;
import org.jberet.rest._private.RestAPIMessages;
import org.jberet.rest.entity.JobInstanceEntity;
import org.jberet.rest.service.JobService;

@Path(value="/jobinstances")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class JobInstanceResource {
    @GET
    public Response getJobInstances(@QueryParam(value="jobName") String jobName, @QueryParam(value="start") int start, @QueryParam(value="count") int count, @QueryParam(value="jobExecutionId") long jobExecutionId) {
        if (jobExecutionId > 0L) {
            JobInstanceEntity jobInstanceData = JobService.getInstance().getJobInstance(jobExecutionId);
            return Response.ok((Object)jobInstanceData).build();
        }
        if (jobExecutionId < 0L) {
            throw RestAPIMessages.MESSAGES.invalidQueryParamValue("jobExecutionId", String.valueOf(jobExecutionId));
        }
        if (start < 0) {
            throw RestAPIMessages.MESSAGES.invalidQueryParamValue("start", String.valueOf(start));
        }
        if (count < 0) {
            throw RestAPIMessages.MESSAGES.invalidQueryParamValue("count", String.valueOf(count));
        }
        JobInstanceEntity[] jobInstanceData = JobService.getInstance().getJobInstances(jobName == null ? "*" : jobName, start, count == 0 ? Integer.MAX_VALUE : count);
        return Response.ok((Object)jobInstanceData).build();
    }

    @Path(value="/count")
    @GET
    public int getJobInstanceCount(@QueryParam(value="jobName") String jobName) {
        if (jobName == null) {
            throw RestAPIMessages.MESSAGES.missingQueryParams("jobName");
        }
        return JobService.getInstance().getJobInstanceCount(jobName);
    }
}

