/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.rest.resource;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.POST;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import jakarta.ws.rs.Produces;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.net.URI;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jberet.rest._private.RestAPIMessages;
import org.jberet.rest.entity.JobEntity;
import org.jberet.rest.entity.JobExecutionEntity;
import org.jberet.rest.entity.JobInstanceEntity;
import org.jberet.rest.resource.JobExecutionResource;
import org.jberet.rest.service.JobService;
import org.jberet.schedule.JobSchedule;
import org.jberet.schedule.JobScheduleConfig;
import org.jberet.schedule.JobScheduler;

@Path(value="jobs")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class JobResource {
    @Path(value="{jobXmlName}/start")
    @POST
    public Response start(@PathParam(value="jobXmlName") String jobXmlName, @Context UriInfo uriInfo, Properties jobParamsAsProps) {
        JobExecutionEntity jobExecutionData = JobService.getInstance().start(jobXmlName, JobResource.jobParametersFromUriInfoAndProps(uriInfo, jobParamsAsProps));
        URI jobExecutionDataUri = uriInfo.getBaseUriBuilder().path(JobExecutionResource.class).path(String.valueOf(jobExecutionData.getExecutionId())).build(new Object[0]);
        jobExecutionData.setHref(jobExecutionDataUri.toString());
        return Response.created((URI)jobExecutionDataUri).entity((Object)jobExecutionData).build();
    }

    @Path(value="submit")
    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    public Response submit(@Context UriInfo uriInfo, String jobDefinition) {
        JobExecutionEntity jobExecutionData = JobService.getInstance().submit(jobDefinition, JobResource.jobParametersFromUriInfoAndProps(uriInfo, null));
        URI jobExecutionDataUri = uriInfo.getBaseUriBuilder().path(JobExecutionResource.class).path(String.valueOf(jobExecutionData.getExecutionId())).build(new Object[0]);
        jobExecutionData.setHref(jobExecutionDataUri.toString());
        return Response.created((URI)jobExecutionDataUri).entity((Object)jobExecutionData).build();
    }

    @Path(value="{jobXmlName}/schedule")
    @POST
    public JobSchedule schedule(@PathParam(value="jobXmlName") String jobXmlName, JobScheduleConfig scheduleConfig) {
        JobScheduler jobScheduler = JobScheduler.getJobScheduler();
        if (scheduleConfig.getJobName() == null) {
            scheduleConfig.setJobName(jobXmlName);
        }
        return jobScheduler.schedule(scheduleConfig);
    }

    @Path(value="{jobXmlName}/restart")
    @POST
    public JobExecutionEntity restart(@PathParam(value="jobXmlName") String jobXmlName, @Context UriInfo uriInfo, Properties jobParamsAsProps) {
        JobInstanceEntity[] jobInstances = JobService.getInstance().getJobInstances(jobXmlName, 0, 1);
        if (jobInstances.length > 0) {
            long latestJobExecutionId = jobInstances[0].getLatestJobExecutionId();
            JobExecutionEntity jobExecutionEntity = JobService.getInstance().restart(latestJobExecutionId, JobResource.jobParametersFromUriInfoAndProps(uriInfo, jobParamsAsProps));
            JobExecutionResource.setJobExecutionEntityHref(uriInfo, jobExecutionEntity);
            return jobExecutionEntity;
        }
        throw RestAPIMessages.MESSAGES.invalidQueryParamValue("jobXmlName", jobXmlName);
    }

    @GET
    public JobEntity[] getJobs() {
        return JobService.getInstance().getJobs();
    }

    static Properties jobParametersFromUriInfoAndProps(UriInfo uriInfo, Properties props) {
        MultivaluedMap queryParameters = uriInfo.getQueryParameters(true);
        if (queryParameters.isEmpty()) {
            return props;
        }
        Properties p = new Properties();
        for (Map.Entry e : queryParameters.entrySet()) {
            p.setProperty((String)e.getKey(), (String)((List)e.getValue()).get(0));
        }
        if (props != null) {
            for (String k : props.stringPropertyNames()) {
                p.setProperty(k, props.getProperty(k));
            }
        }
        return p;
    }
}

