/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.IOException;
import java.io.InputStream;
import javax.batch.api.BatchProperty;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ExcelUserModelItemWriter;

@Named
@Dependent
public class ExcelStreamingItemWriter
extends ExcelUserModelItemWriter {
    @Inject
    @BatchProperty
    Boolean compressTempFiles;

    @Override
    protected Workbook createWorkbook(InputStream templateInputStream) throws IOException, InvalidFormatException {
        SXSSFWorkbook workbook1;
        if (templateInputStream != null) {
            Workbook template = WorkbookFactory.create((InputStream)templateInputStream);
            if (template instanceof XSSFWorkbook) {
                this.workbook = this.compressTempFiles == Boolean.TRUE ? new SXSSFWorkbook((XSSFWorkbook)template, -1, this.compressTempFiles.booleanValue()) : new SXSSFWorkbook((XSSFWorkbook)template, -1);
                return template;
            }
            throw SupportMessages.MESSAGES.incompatibleExcelFileFormat(this.templateResource);
        }
        if (this.resource.endsWith("xlsx")) {
            workbook1 = new SXSSFWorkbook(-1);
            if (this.compressTempFiles == Boolean.TRUE) {
                workbook1.setCompressTempFiles(true);
            }
        } else {
            throw SupportMessages.MESSAGES.incompatibleExcelFileFormat(this.resource);
        }
        this.workbook = workbook1;
        return null;
    }
}

