/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import com.mongodb.util.JSON;
import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.MongoItemReaderWriterBase;
import org.mongojack.DBCursor;

@Named
public class MongoItemReader
extends MongoItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected String criteria;
    @Inject
    @BatchProperty
    protected String projection;
    @Inject
    @BatchProperty
    protected int limit;
    @Inject
    @BatchProperty
    protected int batchSize;
    @Inject
    @BatchProperty
    protected String sort;
    @Inject
    @BatchProperty
    protected int skip;
    protected DBCursor<Object> cursor;

    public void open(Serializable checkpoint) throws Exception {
        super.init();
        BasicDBObject query = this.criteria == null ? new BasicDBObject() : (DBObject)JSON.parse((String)this.criteria);
        DBCursor dBCursor = this.cursor = this.projection == null ? this.jacksonCollection.find((DBObject)query) : this.jacksonCollection.find((DBObject)query, (DBObject)JSON.parse((String)this.projection));
        if (this.limit != 0) {
            this.cursor.limit(this.limit);
        }
        if (this.sort != null) {
            this.cursor.sort((DBObject)JSON.parse((String)this.sort));
        }
        if (checkpoint != null) {
            this.cursor.skip(((Integer)checkpoint).intValue());
        } else if (this.skip > 0) {
            this.cursor.skip(this.skip);
        }
        if (this.batchSize != 0) {
            this.cursor.batchSize(this.batchSize);
        }
    }

    public Object readItem() throws Exception {
        if (this.cursor.hasNext()) {
            Object readValue = this.cursor.next();
            if (!this.skipBeanValidation) {
                ItemReaderWriterBase.validate(readValue);
            }
            return readValue;
        }
        return null;
    }

    public void close() throws Exception {
        if (this.cursor != null) {
            this.cursor.close();
            this.cursor = null;
        }
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.cursor.numSeen() - 1);
    }
}

