/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.lang.reflect.Constructor;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.CsvItemReader;
import org.jberet.support.io.CsvItemReaderWriterBase;
import org.supercsv.cellprocessor.CellProcessorAdaptor;
import org.supercsv.cellprocessor.ConvertNullTo;
import org.supercsv.cellprocessor.FmtBool;
import org.supercsv.cellprocessor.FmtDate;
import org.supercsv.cellprocessor.FmtNumber;
import org.supercsv.cellprocessor.Optional;
import org.supercsv.cellprocessor.ParseBigDecimal;
import org.supercsv.cellprocessor.ParseBool;
import org.supercsv.cellprocessor.ParseChar;
import org.supercsv.cellprocessor.ParseDate;
import org.supercsv.cellprocessor.ParseDouble;
import org.supercsv.cellprocessor.ParseInt;
import org.supercsv.cellprocessor.ParseLong;
import org.supercsv.cellprocessor.StrReplace;
import org.supercsv.cellprocessor.Token;
import org.supercsv.cellprocessor.Trim;
import org.supercsv.cellprocessor.Truncate;
import org.supercsv.cellprocessor.constraint.DMinMax;
import org.supercsv.cellprocessor.constraint.Equals;
import org.supercsv.cellprocessor.constraint.ForbidSubStr;
import org.supercsv.cellprocessor.constraint.IsElementOf;
import org.supercsv.cellprocessor.constraint.IsIncludedIn;
import org.supercsv.cellprocessor.constraint.LMinMax;
import org.supercsv.cellprocessor.constraint.NotNull;
import org.supercsv.cellprocessor.constraint.RequireHashCode;
import org.supercsv.cellprocessor.constraint.RequireSubStr;
import org.supercsv.cellprocessor.constraint.StrMinMax;
import org.supercsv.cellprocessor.constraint.StrNotNullOrEmpty;
import org.supercsv.cellprocessor.constraint.StrRegEx;
import org.supercsv.cellprocessor.constraint.Strlen;
import org.supercsv.cellprocessor.constraint.Unique;
import org.supercsv.cellprocessor.constraint.UniqueHashCode;
import org.supercsv.cellprocessor.ift.BoolCellProcessor;
import org.supercsv.cellprocessor.ift.CellProcessor;
import org.supercsv.cellprocessor.ift.DateCellProcessor;
import org.supercsv.cellprocessor.ift.DoubleCellProcessor;
import org.supercsv.cellprocessor.ift.LongCellProcessor;
import org.supercsv.cellprocessor.ift.StringCellProcessor;
import org.supercsv.util.CsvContext;

final class CellProcessorConfig {
    static final String[] EMPTY_STRING_ARRAY = new String[0];

    CellProcessorConfig() {
    }

    static CellProcessor[] parseCellProcessors(String val) {
        String[] parts = val.split(";");
        CellProcessor[] result = new CellProcessor[parts.length];
        for (int x = 0; x < parts.length; ++x) {
            int i;
            String line = parts[x].trim();
            char[] chars = line.toCharArray();
            ArrayList<List<String>> processorValuesInThisLine = new ArrayList<List<String>>();
            ArrayList<String> oneProcessorValue = new ArrayList<String>();
            int processorStartPosition = 0;
            int paramStartPosition = 0;
            int insideParams = 0;
            int insideQuote = 0;
            block7: for (i = 0; i < chars.length; ++i) {
                char ch = chars[i];
                switch (ch) {
                    case '(': {
                        if (insideQuote != 0) continue block7;
                        if (insideParams == 0) {
                            insideParams = (byte)(insideParams + 1);
                            String s = line.substring(processorStartPosition, i).trim();
                            if (!s.isEmpty()) {
                                oneProcessorValue.add(s);
                            }
                            paramStartPosition = i + 1;
                            continue block7;
                        }
                        throw SupportMessages.MESSAGES.unexpectedChar(ch, i, line);
                    }
                    case ')': {
                        if (insideQuote != 0 && (insideQuote != true || i != chars.length - 1)) continue block7;
                        if (insideParams == 1) {
                            insideParams = (byte)(insideParams - 1);
                            CellProcessorConfig.addParam(line, paramStartPosition, i, oneProcessorValue);
                            CellProcessorConfig.endCurrentProcessor(line, processorStartPosition, i, oneProcessorValue, processorValuesInThisLine, true);
                            processorStartPosition = i + 1;
                            oneProcessorValue = new ArrayList();
                            continue block7;
                        }
                        throw SupportMessages.MESSAGES.unexpectedChar(ch, i, line);
                    }
                    case '\'': {
                        if (insideQuote == 0) {
                            insideQuote = (byte)(insideQuote + 1);
                            continue block7;
                        }
                        if (insideQuote == 1) {
                            insideQuote = (byte)(insideQuote - 1);
                            continue block7;
                        }
                        throw SupportMessages.MESSAGES.unexpectedChar(ch, i, line);
                    }
                    case ',': {
                        if (insideQuote != 0) continue block7;
                        if (insideParams == 0) {
                            CellProcessorConfig.endCurrentProcessor(line, processorStartPosition, i, oneProcessorValue, processorValuesInThisLine, false);
                            processorStartPosition = i + 1;
                            oneProcessorValue = new ArrayList();
                            continue block7;
                        }
                        if (insideParams == 1) {
                            CellProcessorConfig.addParam(line, paramStartPosition, i, oneProcessorValue);
                            paramStartPosition = i + 1;
                            continue block7;
                        }
                        throw SupportMessages.MESSAGES.unexpectedChar(ch, i, line);
                    }
                }
            }
            if (insideQuote == 1) {
                SupportLogger.LOGGER.maybeMissingEndQuote(line);
            }
            if (processorStartPosition < i) {
                oneProcessorValue.add(line.substring(processorStartPosition, i).trim());
            }
            if (!oneProcessorValue.isEmpty() && !processorValuesInThisLine.contains(oneProcessorValue)) {
                processorValuesInThisLine.add(oneProcessorValue);
            }
            result[x] = CellProcessorConfig.createCellProcessorForOneLine(processorValuesInThisLine);
        }
        return result;
    }

    private static void endCurrentProcessor(String line, int processorStartPosition, int currentPosition, List<String> oneProcessorValue, List<List<String>> processorValuesInThisLine, boolean endsWithParenthesis) {
        String s;
        if (!endsWithParenthesis && !(s = line.substring(processorStartPosition, currentPosition).trim()).isEmpty()) {
            oneProcessorValue.add(s);
        }
        if (!oneProcessorValue.isEmpty()) {
            processorValuesInThisLine.add(oneProcessorValue);
        }
    }

    private static void addParam(String line, int paramStartPosition, int currentPosition, List<String> oneProcessorValue) {
        String s = line.substring(paramStartPosition, currentPosition).trim();
        if (!s.isEmpty()) {
            if (s.startsWith("'")) {
                if (s.endsWith("'")) {
                    s = s.substring(1, s.length() - 1);
                } else {
                    SupportLogger.LOGGER.maybeMissingEndQuote(line);
                    s = s.substring(1, s.length());
                }
            }
            oneProcessorValue.add(s);
        }
    }

    static CellProcessor createCellProcessorForOneLine(List<List<String>> processorValuesInThisLine) {
        Object current = null;
        for (int x = processorValuesInThisLine.size() - 1; x >= 0; --x) {
            Object[] params;
            NotNull previous = current;
            current = null;
            List<String> oneProcessorValue = processorValuesInThisLine.get(x);
            SupportLogger.LOGGER.tracef("About to create CSV CellProcessor from %s%n", oneProcessorValue);
            String name = oneProcessorValue.get(0);
            if (oneProcessorValue.size() == 1) {
                params = EMPTY_STRING_ARRAY;
            } else {
                params = new String[oneProcessorValue.size() - 1];
                for (int i = 1; i < oneProcessorValue.size(); ++i) {
                    params[i - 1] = oneProcessorValue.get(i);
                }
            }
            if (name.equalsIgnoreCase("null")) {
                current = null;
                break;
            }
            if (name.equalsIgnoreCase("NotNull")) {
                if (params.length > 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                current = previous == null ? new NotNull() : new NotNull(previous);
                continue;
            }
            if (name.equalsIgnoreCase("Optional")) {
                if (params.length > 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                current = previous == null ? new Optional() : new Optional((CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("ParseBool")) {
                if (params.length == 0) {
                    current = previous == null ? new ParseBool() : new ParseBool((BoolCellProcessor)previous);
                    continue;
                }
                if (params.length == 2) {
                    String[] trueValues = params[0].trim().split("\\s*,\\s*");
                    String[] falseValues = params[1].trim().split("\\s*,\\s*");
                    current = previous == null ? new ParseBool(trueValues, falseValues) : new ParseBool(trueValues, falseValues, (BoolCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("ParseChar")) {
                if (params.length > 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                current = previous == null ? new ParseChar() : new ParseChar((DoubleCellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("ParseDate")) {
                if (params.length == 1) {
                    current = previous == null ? new ParseDate(params[0]) : new ParseDate(params[0], (DateCellProcessor)previous);
                    continue;
                }
                if (params.length == 2) {
                    current = previous == null ? new ParseDate(params[0], Boolean.parseBoolean(params[1])) : new ParseDate(params[0], Boolean.parseBoolean(params[1]), (DateCellProcessor)previous);
                    continue;
                }
                if (params.length == 3) {
                    current = previous == null ? new ParseDate(params[0], Boolean.parseBoolean(params[1]), new Locale(params[2])) : new ParseDate(params[0], Boolean.parseBoolean(params[1]), new Locale(params[2]), (DateCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("ParseDouble")) {
                if (params.length == 0) {
                    current = previous == null ? new ParseDouble() : new ParseDouble((DoubleCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("ParseInt")) {
                if (params.length == 0) {
                    current = previous == null ? new ParseInt() : new ParseInt((LongCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("ParseLong")) {
                if (params.length == 0) {
                    current = previous == null ? new ParseLong() : new ParseLong((LongCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("ParseBigDecimal")) {
                if (params.length == 0) {
                    current = previous == null ? new ParseBigDecimal() : new ParseBigDecimal((CellProcessor)previous);
                    continue;
                }
                if (params.length == 1) {
                    current = previous == null ? new ParseBigDecimal(new DecimalFormatSymbols(new Locale(params[0]))) : new ParseBigDecimal(new DecimalFormatSymbols(new Locale(params[0])), (CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("Truncate")) {
                if (params.length == 1) {
                    current = previous == null ? new Truncate(Integer.parseInt(params[0])) : new Truncate(Integer.parseInt(params[0]), (StringCellProcessor)previous);
                    continue;
                }
                if (params.length == 2) {
                    current = previous == null ? new Truncate(Integer.parseInt(params[0]), params[1]) : new Truncate(Integer.parseInt(params[0]), params[1], (StringCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("Trim")) {
                if (params.length == 0) {
                    current = previous == null ? new Trim() : new Trim((StringCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("Token")) {
                if (params.length == 2) {
                    current = previous == null ? new Token((Object)params[0], (Object)params[1]) : new Token((Object)params[0], (Object)params[1], (CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("StrReplace")) {
                if (params.length == 2) {
                    current = previous == null ? new StrReplace(params[0], params[1]) : new StrReplace(params[0], params[1], (StringCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("ConvertNullTo")) {
                if (params.length == 1) {
                    current = previous == null ? new ConvertNullTo((Object)params[0]) : new ConvertNullTo((Object)params[0], (CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("FmtNumber")) {
                if (params.length == 1) {
                    current = previous == null ? new FmtNumber(params[0]) : new FmtNumber(params[0], (StringCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("FmtDate")) {
                if (params.length == 1) {
                    current = previous == null ? new FmtDate(params[0]) : new FmtDate(params[0], (StringCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("FmtBool")) {
                if (params.length == 2) {
                    current = previous == null ? new FmtBool(params[0], params[1]) : new FmtBool(params[0], params[1], (StringCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("DMinMax")) {
                if (params.length == 2) {
                    current = previous == null ? new DMinMax(Double.parseDouble(params[0]), Double.parseDouble(params[1])) : new DMinMax(Double.parseDouble(params[0]), Double.parseDouble(params[1]), (DoubleCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("Equals")) {
                if (params.length == 0) {
                    current = previous == null ? new Equals() : new Equals((CellProcessor)previous);
                    continue;
                }
                if (params.length != 1) continue;
                current = previous == null ? new Equals((Object)params[0]) : new Equals((Object)params[0], (CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("ForbidSubStr")) {
                if (params.length == 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                current = previous == null ? new ForbidSubStr((String[])params) : new ForbidSubStr((String[])params, (CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("IsElementOf")) {
                if (params.length == 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                ArrayList coll = new ArrayList();
                Collections.addAll(coll, params);
                current = previous == null ? new IsElementOf(coll) : new IsElementOf(coll, (CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("IsIncludedIn")) {
                if (params.length == 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                current = previous == null ? new IsIncludedIn(params) : new IsIncludedIn(params, (CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("LMinMax")) {
                if (params.length == 2) {
                    current = previous == null ? new LMinMax(Long.parseLong((String)params[0]), Long.parseLong((String)params[1])) : new LMinMax(Long.parseLong((String)params[0]), Long.parseLong((String)params[1]), (LongCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("RequireHashCode")) {
                if (params.length == 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                if (params.length == 1) {
                    current = previous == null ? new RequireHashCode(new int[]{Integer.parseInt((String)params[0])}) : new RequireHashCode(Integer.parseInt((String)params[0]), (CellProcessor)previous);
                    continue;
                }
                current = previous == null ? new RequireHashCode(CsvItemReader.convertToIntParams((String[])params, 0, params.length)) : new RequireHashCode(CsvItemReader.convertToIntParams((String[])params, 0, params.length), (CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("RequireSubStr")) {
                if (params.length == 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                if (params.length == 1) {
                    current = previous == null ? new RequireSubStr(new String[]{params[0]}) : new RequireSubStr((String)params[0], (CellProcessor)previous);
                    continue;
                }
                current = previous == null ? new RequireSubStr((String[])params) : new RequireSubStr((String[])params, (CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("Strlen")) {
                if (params.length == 0) {
                    throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
                }
                if (params.length == 1) {
                    current = previous == null ? new Strlen(new int[]{Integer.parseInt((String)params[0])}) : new Strlen(Integer.parseInt((String)params[0]), (CellProcessor)previous);
                    continue;
                }
                current = previous == null ? new Strlen(CsvItemReader.convertToIntParams((String[])params, 0, params.length)) : new Strlen(CsvItemReader.convertToIntParams((String[])params, 0, params.length), (CellProcessor)previous);
                continue;
            }
            if (name.equalsIgnoreCase("StrMinMax")) {
                if (params.length == 2) {
                    current = previous == null ? new StrMinMax(Long.parseLong((String)params[0]), Long.parseLong((String)params[1])) : new StrMinMax(Long.parseLong((String)params[0]), Long.parseLong((String)params[1]), (CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("StrNotNullOrEmpty")) {
                if (params.length == 0) {
                    current = previous == null ? new StrNotNullOrEmpty() : new StrNotNullOrEmpty((CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("StrRegEx")) {
                if (params.length == 1) {
                    current = previous == null ? new StrRegEx((String)params[0]) : new StrRegEx((String)params[0], (StringCellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("Unique")) {
                if (params.length == 0) {
                    current = previous == null ? new Unique() : new Unique((CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("UniqueHashCode")) {
                if (params.length == 0) {
                    current = previous == null ? new UniqueHashCode() : new UniqueHashCode((CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("ParseEnum")) {
                if (params.length == 1) {
                    current = previous == null ? new ParseEnum((String)params[0]) : new ParseEnum((String)params[0], (CellProcessor)previous);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidParamsForCellProcessor(name, (String[])params);
            }
            if (name.equalsIgnoreCase("Collector") || name.equalsIgnoreCase("HashMapper")) {
                throw SupportMessages.MESSAGES.unsupportedCellProcessor(name, (String[])params);
            }
            current = CellProcessorConfig.createCustomCellProcessor(name, (String[])params, oneProcessorValue, (CellProcessor)previous);
        }
        return current;
    }

    private static CellProcessor createCustomCellProcessor(String name, String[] params, List<String> oneProcessorValue, CellProcessor previous) {
        CellProcessor result;
        try {
            Class<?> cellProcessorClass = CellProcessorConfig.class.getClassLoader().loadClass(name);
            if (params.length == 0) {
                if (previous == null) {
                    result = (CellProcessor)cellProcessorClass.newInstance();
                } else {
                    Class[] constructorParamTypes = new Class[]{CellProcessor.class};
                    Constructor<?> constructor = cellProcessorClass.getConstructor(constructorParamTypes);
                    result = (CellProcessor)constructor.newInstance(previous);
                }
            } else if (params.length == 1) {
                if (previous == null) {
                    Class[] constructorParamTypes = CsvItemReaderWriterBase.stringParameterTypes;
                    Constructor<?> constructor = cellProcessorClass.getConstructor(constructorParamTypes);
                    result = (CellProcessor)constructor.newInstance(params[0]);
                } else {
                    Class[] constructorParamTypes = new Class[]{String.class, CellProcessor.class};
                    Constructor<?> constructor = cellProcessorClass.getConstructor(constructorParamTypes);
                    result = (CellProcessor)constructor.newInstance(params[0], previous);
                }
            } else if (previous == null) {
                Class[] constructorParamTypes = new Class[]{String[].class};
                Constructor<?> constructor = cellProcessorClass.getConstructor(constructorParamTypes);
                result = (CellProcessor)constructor.newInstance(params);
            } else {
                Class[] constructorParamTypes = new Class[]{String[].class, CellProcessor.class};
                Constructor<?> constructor = cellProcessorClass.getConstructor(constructorParamTypes);
                result = (CellProcessor)constructor.newInstance(params, previous);
            }
        }
        catch (Exception e) {
            throw SupportMessages.MESSAGES.failToLoadOrCreateCustomType(e, oneProcessorValue.toString());
        }
        return result;
    }

    static final class ParseEnum
    extends CellProcessorAdaptor {
        private final String enumType;

        ParseEnum(String enumType) {
            this.enumType = enumType;
        }

        ParseEnum(String enumType, CellProcessor next) {
            super(next);
            this.enumType = enumType;
        }

        public Object execute(Object value, CsvContext context) {
            this.validateInputNotNull(value, context);
            try {
                Class<?> aClass = ((Object)((Object)this)).getClass().getClassLoader().loadClass(this.enumType);
                if (aClass.isEnum()) {
                    ?[] enumConstants;
                    for (Object e : enumConstants = aClass.getEnumConstants()) {
                        if (!value.equals(e.toString())) continue;
                        return this.next.execute(e, context);
                    }
                }
            }
            catch (Exception e) {
                throw SupportMessages.MESSAGES.failToParseEnum(e, value, this.enumType, context, (CellProcessor)this);
            }
            throw SupportMessages.MESSAGES.failToParseEnum(null, value, this.enumType, context, (CellProcessor)this);
        }
    }
}

