/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.io.Serializable;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.hornetq.api.core.HornetQException;
import org.hornetq.api.core.client.ClientConsumer;
import org.hornetq.api.core.client.ClientMessage;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.HornetQItemReaderWriterBase;
import org.jberet.support.io.ItemReaderWriterBase;

@Named
@Dependent
public class HornetQItemReader
extends HornetQItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected long receiveTimeout;
    @Inject
    @BatchProperty
    protected Class beanType;
    protected ClientConsumer consumer;

    @Override
    public void open(Serializable checkpoint) throws Exception {
        super.open(checkpoint);
        this.consumer = this.session.createConsumer(this.queueName);
        this.session.start();
    }

    public Object readItem() throws Exception {
        Object result;
        ClientMessage message = this.consumer.receive(this.receiveTimeout);
        if (message == null) {
            return null;
        }
        int bodySize = message.getBodySize();
        if (bodySize == 0) {
            return null;
        }
        if (this.beanType == ClientMessage.class) {
            return message;
        }
        byte messageType = message.getType();
        byte[] bytes = new byte[bodySize];
        message.getBodyBuffer().readBytes(bytes);
        if (messageType == 3) {
            result = new String(bytes);
        } else {
            result = HornetQItemReader.bytesToSerializableObject(bytes);
            if (!this.skipBeanValidation) {
                ItemReaderWriterBase.validate(result);
            }
        }
        return result;
    }

    @Override
    public void close() {
        super.close();
        if (this.consumer != null) {
            try {
                this.consumer.close();
            }
            catch (HornetQException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close HornetQ consumer %s%n", this.consumer);
            }
            this.consumer = null;
        }
    }
}

