/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import javax.batch.api.BatchProperty;
import javax.batch.api.chunk.ItemReader;
import javax.enterprise.context.Dependent;
import javax.inject.Inject;
import javax.inject.Named;
import org.jberet.support._private.SupportLogger;
import org.jberet.support._private.SupportMessages;
import org.jberet.support.io.ItemReaderWriterBase;
import org.jberet.support.io.JacksonCsvItemReaderWriterBase;
import org.jberet.support.io.JsonItemReader;

@Named
@Dependent
public class JacksonCsvItemReader
extends JacksonCsvItemReaderWriterBase
implements ItemReader {
    @Inject
    @BatchProperty
    protected int start;
    @Inject
    @BatchProperty
    protected int end;
    @Inject
    @BatchProperty
    protected String skipFirstDataRow;
    @Inject
    @BatchProperty
    protected String escapeChar;
    @Inject
    @BatchProperty
    protected Map<String, String> jsonParserFeatures;
    @Inject
    @BatchProperty
    protected Map<String, String> csvParserFeatures;
    @Inject
    @BatchProperty
    protected String deserializationProblemHandlers;
    @Inject
    @BatchProperty
    protected Class inputDecorator;
    private CsvParser csvParser;
    private int rowNumber;
    private boolean rawAccess;

    public void open(Serializable checkpoint) throws Exception {
        if (this.end == 0) {
            this.end = Integer.MAX_VALUE;
        }
        if (checkpoint != null) {
            this.start = (Integer)checkpoint;
        }
        if (this.start > this.end) {
            throw SupportMessages.MESSAGES.invalidStartPosition((Integer)checkpoint, this.start, this.end);
        }
        this.init();
        this.csvParser = (CsvParser)JsonItemReader.configureJsonParser(this, this.inputDecorator, this.deserializationProblemHandlers, this.jsonParserFeatures);
        if (this.csvParserFeatures != null) {
            for (Map.Entry<String, String> e : this.csvParserFeatures.entrySet()) {
                CsvParser.Feature feature;
                String key = e.getKey();
                String value = e.getValue();
                try {
                    feature = CsvParser.Feature.valueOf((String)key);
                }
                catch (Exception e1) {
                    throw SupportMessages.MESSAGES.unrecognizedReaderWriterProperty(key, value);
                }
                if ("true".equals(value)) {
                    if (feature.enabledByDefault()) continue;
                    this.csvParser.configure(feature, true);
                    continue;
                }
                if ("false".equals(value)) {
                    if (!feature.enabledByDefault()) continue;
                    this.csvParser.configure(feature, false);
                    continue;
                }
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, value, key);
            }
        }
        boolean bl = this.rawAccess = this.beanType == List.class || this.beanType == String[].class;
        if (!this.rawAccess) {
            CsvSchema schema;
            if (this.columns != null) {
                schema = this.buildCsvSchema(null);
            } else if (this.useHeader) {
                schema = this.buildCsvSchema(CsvSchema.emptySchema());
            } else {
                throw SupportMessages.MESSAGES.invalidReaderWriterProperty(null, this.columns, "columns");
            }
            if (this.escapeChar != null) {
                schema = schema.withEscapeChar(this.escapeChar.charAt(0));
            }
            if (this.skipFirstDataRow != null) {
                schema = schema.withSkipFirstDataRow(Boolean.parseBoolean(this.skipFirstDataRow.trim()));
            }
            this.csvParser.setSchema((FormatSchema)schema);
        }
    }

    public void close() throws Exception {
        if (this.csvParser != null) {
            SupportLogger.LOGGER.closingResource(this.resource, this.getClass());
            if (this.deserializationProblemHandlers != null) {
                this.objectMapper.clearProblemHandlers();
            }
            this.csvParser.close();
            this.csvParser = null;
        }
    }

    public Object readItem() throws Exception {
        Object readValue;
        if (this.rowNumber >= this.end) {
            return null;
        }
        if (!this.rawAccess) {
            JsonToken token;
            do {
                if ((token = this.csvParser.nextToken()) != null) continue;
                return null;
            } while (token != JsonToken.START_OBJECT || ++this.rowNumber < this.start);
            readValue = this.objectMapper.readValue((JsonParser)this.csvParser, this.beanType);
            if (!this.skipBeanValidation) {
                ItemReaderWriterBase.validate(readValue);
            }
        } else {
            JsonToken token;
            do {
                if ((token = this.csvParser.nextToken()) != null) continue;
                return null;
            } while (token != JsonToken.START_ARRAY || ++this.rowNumber < this.start);
            readValue = this.objectMapper.readValue((JsonParser)this.csvParser, this.beanType);
        }
        return readValue;
    }

    public Serializable checkpointInfo() throws Exception {
        return Integer.valueOf(this.rowNumber);
    }
}

