/*
 * Decompiled with CFR 0.152.
 */
package org.jberet.support.io;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.batch.api.BatchProperty;
import javax.inject.Inject;
import javax.naming.InitialContext;
import javax.sql.DataSource;
import org.jberet.support._private.SupportLogger;
import org.jberet.support.io.JsonItemReaderWriterBase;

public abstract class JdbcItemReaderWriterBase
extends JsonItemReaderWriterBase {
    @Inject
    @BatchProperty
    protected String sql;
    @Inject
    @BatchProperty
    protected Class beanType;
    @Inject
    @BatchProperty
    protected String dataSourceLookup;
    @Inject
    @BatchProperty
    protected String url;
    @Inject
    @BatchProperty
    protected String user;
    @Inject
    @BatchProperty
    protected String password;
    @Inject
    @BatchProperty
    protected Map<String, String> properties;
    protected PreparedStatement preparedStatement;
    protected DataSource dataSource;
    private Properties dbProperties;

    protected void init() throws Exception {
        if (this.dataSourceLookup != null) {
            this.dataSource = (DataSource)InitialContext.doLookup(this.dataSourceLookup);
        } else {
            this.dbProperties = new Properties();
            if (this.properties != null) {
                this.dbProperties.putAll(this.properties);
            }
            if (this.user != null) {
                this.dbProperties.put("user", this.user.trim());
            }
            if (this.password != null) {
                this.dbProperties.put("password", this.password.trim());
            }
        }
        if (this.beanType != List.class && this.beanType != Map.class) {
            this.initJsonFactoryAndObjectMapper();
        }
    }

    protected Connection getConnection() throws Exception {
        if (this.dataSource != null) {
            return this.dataSource.getConnection();
        }
        return DriverManager.getConnection(this.url, this.dbProperties);
    }

    protected static void close(Connection connection, PreparedStatement preparedStatement) {
        if (preparedStatement != null) {
            try {
                preparedStatement.close();
            }
            catch (SQLException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close PreparedStatement", new Object[0]);
            }
        }
        if (connection != null) {
            try {
                connection.close();
            }
            catch (SQLException e) {
                SupportLogger.LOGGER.tracef(e, "Failed to close connection.", new Object[0]);
            }
        }
    }
}

